/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.AbstractMangoFruitBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingMangoFruitBlock
extends AbstractMangoFruitBlock {
    private static final VoxelShape STAGE_0 = Block.box((double)6.5, (double)7.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
    private static final VoxelShape STAGE_FULL = Block.box((double)5.5, (double)5.0, (double)5.5, (double)10.5, (double)16.0, (double)10.5);

    public HangingMangoFruitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)FALLING, (Comparable)Boolean.valueOf(false)));
    }

    public float getMaxVerticalOffset() {
        return 0.05f;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.above());
        return blockState.is(FOTBlocks.MANGO_LEAVES);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int age = Math.min((Integer)state.getValue((Property)AGE), 1);
        Vec3 offset = state.getOffset(pos);
        return (age == 0 ? STAGE_0 : STAGE_FULL).move(offset.x, offset.y, offset.z);
    }
}

