/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.AbstractMangoFruitBlock;
import com.stevekung.fishofthieves.block.MangoFruitBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MangoLeavesBlock
extends TintedParticleLeavesBlock
implements BonemealableBlock {
    public MangoLeavesBlock(BlockBehaviour.Properties properties) {
        super(0.05f, properties);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return Direction.stream().filter(direction -> direction != Direction.UP).anyMatch(direction -> level.getBlockState(pos.relative(direction)).isAir());
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growMangos(level, random, pos);
    }

    private void growMangos(ServerLevel level, RandomSource random, BlockPos pos) {
        Direction.allShuffled((RandomSource)random).stream().filter(direction -> direction != Direction.UP && level.getBlockState(pos.relative(direction)).isAir()).findFirst().ifPresent(direction -> this.setMangoBlock(level, pos, random, (Direction)direction));
    }

    private void setMangoBlock(ServerLevel level, BlockPos pos, RandomSource random, Direction direction) {
        if (direction == Direction.DOWN) {
            level.setBlock(pos.relative(direction), (BlockState)FOTBlocks.HANGING_MANGO_FRUIT.defaultBlockState().setValue((Property)AbstractMangoFruitBlock.FALLING, (Comparable)Boolean.valueOf(random.nextFloat() < 0.6f)), 2);
        } else {
            level.setBlock(pos.relative(direction), (BlockState)((BlockState)FOTBlocks.MANGO_FRUIT.defaultBlockState().setValue(MangoFruitBlock.FACING, (Comparable)direction.getOpposite())).setValue((Property)AbstractMangoFruitBlock.FALLING, (Comparable)Boolean.valueOf(random.nextFloat() < 0.6f)), 2);
        }
    }
}

