/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PineappleCropBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)5);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    private static final VoxelShape STAGE_3_SHAPE = Shapes.join((VoxelShape)Block.box((double)6.5, (double)9.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), (VoxelShape)BASE_SHAPE, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape STAGE_4_COLLISION_SHAPE = Block.box((double)5.0, (double)-7.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    private static final VoxelShape STAGE_4_LOWER_SHAPE = Shapes.join((VoxelShape)Block.box((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), (VoxelShape)BASE_SHAPE, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape STAGE_4_SHAPE = Shapes.join((VoxelShape)STAGE_4_COLLISION_SHAPE, (VoxelShape)Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape STAGE_5_COLLISION_SHAPE = Shapes.join((VoxelShape)Block.box((double)6.0, (double)-7.0, (double)6.0, (double)10.0, (double)-6.0, (double)10.0), (VoxelShape)Block.box((double)4.0, (double)-6.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape STAGE_5_LOWER_SHAPE = Stream.of(Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0), BASE_SHAPE).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape STAGE_5_SHAPE = Stream.of(STAGE_5_COLLISION_SHAPE, Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public PineappleCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    private int getMaxAge() {
        return 5;
    }

    private boolean isLowerAge(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < this.getMaxAge();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && this.isLowerAge(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.getValue((Property)AGE);
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            if (age == 4) {
                return STAGE_4_COLLISION_SHAPE;
            }
            if (age == 5) {
                return STAGE_5_COLLISION_SHAPE;
            }
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (!PineappleCropBlock.isLower(state) && (Integer)state.getValue((Property)AGE) >= 4) {
            float destroySpeed = 0.6f;
            int i = player.hasCorrectToolForDrops(state) ? 30 : 100;
            return player.getDestroySpeed(state) / destroySpeed / (float)i;
        }
        return super.getDestroyProgress(state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state) {
        Integer age;
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER && (age = (Integer)state.getValue((Property)AGE)) >= 4) {
            return SoundType.WOOD;
        }
        return super.getSoundType(state);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (!PineappleCropBlock.sufficientLight(level, pos)) {
            return false;
        }
        return super.canSurvive(state, level, pos);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(Blocks.FARMLAND) || state.is(BlockTags.DIRT);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{AGE}));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        Integer age = (Integer)state.getValue((Property)AGE);
        if (!level.isClientSide() && age >= 4 && EnchantmentHelper.hasTag((ItemStack)player.getMainHandItem(), FOTTags.Enchantments.DROP_PINEAPPLE_BLOCK_WHEN_MINING)) {
            PineappleCropBlock.preventDropFromBottomPart((Level)level, (BlockPos)pos, (BlockState)state, (Player)player);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age == 3) {
            return STAGE_3_SHAPE;
        }
        if (age == 4) {
            return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? STAGE_4_SHAPE : STAGE_4_LOWER_SHAPE;
        }
        if (age == 5) {
            return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? STAGE_5_SHAPE : STAGE_5_LOWER_SHAPE;
        }
        return BASE_SHAPE;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier insideBlockEffectApplier, boolean intersectInsideBlock) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof Ravager && serverLevel.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                serverLevel.destroyBlock(pos, true, entity);
            }
        }
        super.entityInside(state, level, pos, entity, insideBlockEffectApplier, intersectInsideBlock);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed = FOTPlatform.getGrowthSpeedFromCropBlock(this.defaultBlockState(), level, pos);
        if (random.nextInt((int)(25.0f / growthSpeed) + 1) == 0) {
            this.grow(level, state, pos, 1);
        }
    }

    private void grow(ServerLevel level, BlockState state, BlockPos pos, int growthAge) {
        int age = Math.min((Integer)state.getValue((Property)AGE) + growthAge, this.getMaxAge());
        if (this.canGrow((LevelReader)level, pos, state, age)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
            if (age >= 4) {
                BlockPos blockPos = pos.above();
                level.setBlock(blockPos, PineappleCropBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(age))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER))), 3);
            }
        }
    }

    private static boolean canGrowInto(LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        return blockState.isAir() || blockState.is(FOTBlocks.PINEAPPLE_CROP);
    }

    private static boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) >= 8 || level.canSeeSky(pos);
    }

    private static boolean isLower(BlockState state) {
        return state.is(FOTBlocks.PINEAPPLE_CROP) && state.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    private boolean canGrow(LevelReader reader, BlockPos pos, BlockState state, int age) {
        return this.isLowerAge(state) && PineappleCropBlock.sufficientLight(reader, pos) && (age < 4 || PineappleCropBlock.canGrowInto(reader, pos.above()));
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader level, BlockPos pos, BlockState state) {
        if (PineappleCropBlock.isLower(state)) {
            return new PosAndState(pos, state);
        }
        BlockPos blockPos = pos.below();
        BlockState blockState = level.getBlockState(blockPos);
        return PineappleCropBlock.isLower(blockState) ? new PosAndState(blockPos, blockState) : null;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        PosAndState posAndState = this.getLowerHalf(level, pos, state);
        return posAndState != null && this.canGrow(level, posAndState.pos, posAndState.state, (Integer)posAndState.state.getValue((Property)AGE) + 1);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        PosAndState posAndState = this.getLowerHalf((LevelReader)level, pos, state);
        if (posAndState != null) {
            this.grow(level, posAndState.state, posAndState.pos, Mth.nextInt((RandomSource)random, (int)1, (int)2));
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            return (Integer)state.getValue((Property)AGE) == 5 ? new ItemStack((ItemLike)FOTBlocks.RIPE_PINEAPPLE_BLOCK) : ((Integer)state.getValue((Property)AGE) == 4 ? new ItemStack((ItemLike)FOTBlocks.UNDERRIPE_PINEAPPLE_BLOCK) : new ItemStack((ItemLike)FOTItems.PINEAPPLE_CROWN));
        }
        return (Integer)state.getValue((Property)AGE) == 0 ? new ItemStack((ItemLike)FOTItems.PINEAPPLE_SEEDS) : new ItemStack((ItemLike)FOTItems.PINEAPPLE_CROWN);
    }

    record PosAndState(BlockPos pos, BlockState state) {
    }
}

