/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.serialization.MapCodec;
import com.stevekung.fishofthieves.block.AbstractBananaClusterBlock;
import com.stevekung.fishofthieves.block.BananaClusterBlock;
import com.stevekung.fishofthieves.block.BananaClusterPlantBlock;
import com.stevekung.fishofthieves.block.BananaHangingType;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UnderripeBananaClusterPlantBlock
extends AbstractBananaClusterBlock
implements BonemealableBlock {
    public static final MapCodec<UnderripeBananaClusterPlantBlock> CODEC = UnderripeBananaClusterPlantBlock.simpleCodec(UnderripeBananaClusterPlantBlock::new);
    private static final Map<Direction, VoxelShape> UNDERRIPE_SHAPES = Map.of(Direction.NORTH, Block.box((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)16.0, (double)10.0), Direction.WEST, Block.box((double)2.0, (double)4.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), Direction.SOUTH, Block.box((double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)16.0, (double)14.0), Direction.EAST, Block.box((double)6.0, (double)4.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0));
    public static final EnumProperty<BananaHangingType> HANGING = EnumProperty.create((String)"hanging", BananaHangingType.class);

    public UnderripeBananaClusterPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HANGING, (Comparable)((Object)BananaHangingType.CLUSTER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (BananaClusterBlock.canClusterPlantGrow((Level)level, pos) && random.nextInt(15) == 0) {
            this.growBananaCluster(level, random, pos, state);
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(8) == 0;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growBananaCluster(level, random, pos, state);
    }

    private void growBananaCluster(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        FluidState fluidState = level.getFluidState(pos);
        BlockState otherCluster = level.getBlockState(pos.above());
        if (random.nextFloat() < 0.4f) {
            level.setBlock(pos, (BlockState)((BlockState)((BlockState)FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.defaultBlockState().setValue(BananaClusterPlantBlock.HANGING, (Comparable)((Object)(state.getValue(HANGING) == BananaHangingType.STEM ? BananaClusterPlantBlock.HangingType.STEM : (otherCluster.is((Block)this) ? BananaClusterPlantBlock.HangingType.SMALL_CLUSTER : BananaClusterPlantBlock.HangingType.NONE))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
        } else {
            level.setBlock(pos, (BlockState)((BlockState)((BlockState)FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT.defaultBlockState().setValue(BananaClusterPlantBlock.HANGING, (Comparable)((Object)(state.getValue(HANGING) == BananaHangingType.STEM ? BananaClusterPlantBlock.HangingType.STEM : (otherCluster.is((Block)this) ? BananaClusterPlantBlock.HangingType.SMALL_CLUSTER : BananaClusterPlantBlock.HangingType.NONE))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return new ItemStack((ItemLike)FOTBlocks.UNDERRIPE_BANANA_CLUSTER);
    }

    @Override
    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (direction == Direction.UP && (neighborState.is(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT) || neighborState.is(FOTBlocks.RIPE_BANANA_CLUSTER_PLANT))) {
            return (BlockState)state.setValue(HANGING, (Comparable)((Object)BananaHangingType.CLUSTER));
        }
        return super.updateShape(state, level, scheduledTickAccess, currentPos, direction, neighborPos, neighborState, randomSource);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.is(FOTTags.Blocks.BANANA_CLUSTER_PLANTS) && !adjacentState.is((Block)this) && direction.getAxis().isVertical();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return UNDERRIPE_SHAPES.get(state.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HANGING, WATERLOGGED});
    }
}

