/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;

public class HeadphoneLayer<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private static final ResourceLocation TEXTURE = FishOfThieves.id("textures/entity/headphone.png");
    private final HeadphoneModel<S> model;
    private final HeadphoneModel.Scaleable<S> scaleable;

    public HeadphoneLayer(LivingEntityRenderer<?, ?, ?> renderLayerParent, EntityModelSet entityModelSet, HeadphoneModel.Scaleable<S> scaleable) {
        super(renderLayerParent);
        this.model = new HeadphoneModel(entityModelSet.bakeLayer(HeadphoneModel.LAYER));
        this.scaleable = scaleable;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, S renderState, float yRot, float xRot) {
        if (!((LivingEntityRenderState)renderState).isInvisible && (renderState.fishofthieves$isSalmon() && ((LivingEntityRenderState)renderState).nameTag != null && ChatFormatting.stripFormatting((String)((LivingEntityRenderState)renderState).nameTag.getString()).equals("Sally") || renderState.fishofthieves$isDancing())) {
            poseStack.pushPose();
            this.scaleable.scale(renderState, poseStack);
            submitNodeCollector.submitModel(this.model, renderState, poseStack, RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE), packedLight, OverlayTexture.NO_OVERLAY, ARGB.color((int)255, (int)255, (int)255), null);
            poseStack.popPose();
        }
    }
}

