/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DataFixUtils;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class CreateFishFlock
extends Behavior<AbstractFlockFish> {
    private static final Predicate<AbstractFlockFish> CAN_BE_FOLLOWED = AbstractFlockFish::canBeFollowed;
    private static final Predicate<AbstractFlockFish> NOT_LEADER = Predicate.not(AbstractFlockFish::isLeader);
    private static final Predicate<AbstractFlockFish> NOT_FOLLOWER = Predicate.not(AbstractFlockFish::isFollower);
    private static final Predicate<AbstractFlockFish> TROPHY = AbstractFlockFish::isTrophy;
    private static final Predicate<AbstractFlockFish> HAS_NO_FOLLOW_COOLDOWN = Predicate.not(AbstractFlockFish::hasFollowCooldown);

    public CreateFishFlock() {
        super((Map)ImmutableMap.of(FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH, (Object)MemoryStatus.VALUE_PRESENT, FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)MemoryStatus.VALUE_PRESENT, FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected void start(ServerLevel level, AbstractFlockFish entity, long gameTime) {
        Optional optional = entity.getBrain().getMemory(FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH);
        if (!entity.isFollower() && !entity.isLeader() && optional.isPresent()) {
            Predicate<AbstractFlockFish> lineOfSight = arg_0 -> ((AbstractFlockFish)entity).hasLineOfSight(arg_0);
            Optional<AbstractFlockFish> nearestFish = ((List)optional.get()).stream().filter(lineOfSight.and(CAN_BE_FOLLOWED).and(NOT_FOLLOWER)).findAny();
            AbstractFlockFish leader = (AbstractFlockFish)((Object)DataFixUtils.orElse(nearestFish, (Object)((Object)entity)));
            if (leader.isTrophy()) {
                leader.addThievesFishFollowers(((List)optional.get()).stream().filter(leader::isSameType).filter(lineOfSight.and(NOT_FOLLOWER).and(NOT_LEADER).and(HAS_NO_FOLLOW_COOLDOWN).and(TROPHY.negate().or(TROPHY))));
            } else {
                Supplier<Stream> supplier = () -> ((List)optional.get()).stream().filter(lineOfSight.and(NOT_FOLLOWER).and(NOT_LEADER));
                supplier.get().filter(TROPHY).findAny().ifPresentOrElse(fish -> fish.addThievesFishFollowers(((Stream)supplier.get()).filter(HAS_NO_FOLLOW_COOLDOWN.and(fish::isSameType))), () -> leader.addThievesFishFollowers(((Stream)supplier.get()).filter(HAS_NO_FOLLOW_COOLDOWN.and(leader::isSameType))));
            }
        }
    }

    public static int nextStartTick(RandomSource randomSource) {
        return CreateFishFlock.nextStartTick(randomSource, 200);
    }

    public static int nextStartTick(RandomSource randomSource, int nextTicks) {
        return Mth.positiveCeilDiv((int)(nextTicks + randomSource.nextInt(nextTicks) % 20), (int)2);
    }
}

