/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.ai.WreckerAi;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTDataComponentTypes;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.WreckerVariants;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.Nullable;

public class Wrecker
extends AbstractThievesFish<WreckerVariant> {
    private static final EntityDataAccessor<Holder<WreckerVariant>> VARIANT = SynchedEntityData.defineId(Wrecker.class, FOTDataSerializers.WRECKER_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:rose", (Object)0);
        map.put((Object)"fishofthieves:sun", (Object)1);
        map.put((Object)"fishofthieves:blackcloud", (Object)2);
        map.put((Object)"fishofthieves:snow", (Object)3);
        map.put((Object)"fishofthieves:moon", (Object)4);
    });
    private static final ImmutableList<SensorType<? extends Sensor<? super Wrecker>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, (Object)SensorType.HURT_BY, FOTSensorTypes.EARTHWORMS_THIEVES_FISH_TEMPTATIONS, FOTSensorTypes.NEAREST_WRECKER_LOCATED, FOTSensorTypes.NEAREST_MAGMA_BLOCK, FOTSensorTypes.WRECKER_ATTACKABLES, FOTSensorTypes.LOW_BRIGHTNESS);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_REPELLENT, FOTMemoryModuleTypes.NEAREST_WRECKER_LOCATED, FOTMemoryModuleTypes.NEAREST_LOW_BRIGHTNESS, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object[])new MemoryModuleType[]{MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, FOTMemoryModuleTypes.BREACHED_TICK});

    public Wrecker(EntityType<? extends Wrecker> entityType, Level level) {
        super(entityType, level, FOTRegistries.WRECKER_VARIANT, WreckerVariants.ROSE, FOTDataComponentTypes.WRECKER_VARIANT);
    }

    protected Brain.Provider<Wrecker> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return WreckerAi.makeBrain((Brain<Wrecker>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Wrecker> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(ServerLevel serverLevel) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("wreckerBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.popPush("wreckerActivityUpdate");
        WreckerAi.updateActivity(this);
        profiler.pop();
        super.customServerAiStep(serverLevel);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.registryAccess().lookupOrThrow(FOTRegistries.WRECKER_VARIANT).getOrThrow(WreckerVariants.ROSE));
    }

    @Override
    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        WreckerAi.initMemories(this);
    }

    @Override
    public Holder<WreckerVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    @Override
    public void setVariant(Holder<WreckerVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)FOTItems.WRECKER_BUCKET);
    }

    protected SoundEvent getDeathSound() {
        return FOTSoundEvents.WRECKER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return FOTSoundEvents.WRECKER_HURT;
    }

    protected SoundEvent getFlopSound() {
        return FOTSoundEvents.WRECKER_FLOP;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isTrophy() ? super.getDefaultDimensions(pose).withEyeHeight(0.34f) : EntityDimensions.fixed((float)0.275f, (float)0.25f).withEyeHeight(0.175f);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason entitySpawnReason, @Nullable SpawnGroupData spawnGroupData) {
        if (this.isTrophy()) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2.5);
        }
        return super.finalizeSpawn(level, difficulty, entitySpawnReason, spawnGroupData);
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2.5);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(EARTHWORMS_FOOD);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, EntitySpawnReason entitySpawnReason, BlockPos blockPos, RandomSource random) {
        boolean isWater = level.getFluidState(blockPos).is(FluidTags.WATER) && level.getBlockState(blockPos).is(Blocks.WATER);
        return isWater && TerrainUtils.isInFeature(level.getLevel(), blockPos, FOTTags.Structures.WRECKERS_SPAWN_IN);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.TEMPT_RANGE, 10.0).add(Attributes.ATTACK_DAMAGE, 1.5).add(Attributes.ATTACK_KNOCKBACK, 0.01);
    }

    @Nullable
    public static BlockPos getNearestShipwreckOrRuinedPortalPos(ServerLevel level, BlockPos pos) {
        return level.findNearestMapStructure(FOTTags.Structures.WRECKERS_LOCATED, pos, 32, false);
    }
}

