/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public record BlockRangeCheck(Optional<HolderSet<Block>> blocks, Optional<HolderSet<Fluid>> fluids, int range) implements SpawnCondition
{
    public static final MapCodec<BlockRangeCheck> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("blocks").forGetter(BlockRangeCheck::blocks), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.FLUID).optionalFieldOf("fluids").forGetter(BlockRangeCheck::fluids), (App)Codec.intRange((int)1, (int)32).fieldOf("range").forGetter(BlockRangeCheck::range)).apply((Applicative)instance, BlockRangeCheck::new));

    public MapCodec<? extends SpawnCondition> codec() {
        return CODEC;
    }

    public boolean test(SpawnContext context) {
        ServerLevel level = context.level().getLevel();
        if (this.blocks.isPresent() && TerrainUtils.lookForBlock(context.pos(), this.range, blockPos2 -> level.getBlockState(blockPos2).is(this.blocks.get())).isPresent()) {
            return true;
        }
        return this.fluids.isPresent() && TerrainUtils.lookForBlock(context.pos(), this.range, blockPos2 -> level.getFluidState(blockPos2).is(this.fluids.get()) && level.getFluidState(blockPos2).isSource()).isPresent();
    }

    public static SpawnCondition blocksInRange(Optional<HolderSet<Block>> blocks, Optional<HolderSet<Fluid>> fluids, int range) {
        return new BlockRangeCheck(blocks, fluids, range);
    }
}

