/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;

public record RainingCheck(Optional<Boolean> thundering) implements SpawnCondition
{
    public static final MapCodec<RainingCheck> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("thundering").forGetter(RainingCheck::thundering)).apply((Applicative)instance, RainingCheck::new));

    public MapCodec<? extends SpawnCondition> codec() {
        return CODEC;
    }

    public boolean test(SpawnContext context) {
        ServerLevel level = context.level().getLevel();
        return level.isRaining() || this.thundering.isPresent() && this.thundering.get().booleanValue() == level.isThundering();
    }

    public static Builder raining() {
        return new Builder();
    }

    public static class Builder {
        private Optional<Boolean> thundering = Optional.empty();

        public Builder thundering(boolean thundering) {
            this.thundering = Optional.of(thundering);
            return this;
        }

        public RainingCheck build() {
            return new RainingCheck(this.thundering);
        }
    }
}

