/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature;

import com.mojang.serialization.Codec;
import com.stevekung.fishofthieves.feature.configurations.SimpleAgeBlockConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class SimpleAgeBlockFeature
extends Feature<SimpleAgeBlockConfiguration> {
    public SimpleAgeBlockFeature(Codec<SimpleAgeBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleAgeBlockConfiguration> context) {
        SimpleAgeBlockConfiguration simpleBlockConfiguration = (SimpleAgeBlockConfiguration)context.config();
        WorldGenLevel worldGenLevel = context.level();
        BlockPos blockPos = context.origin();
        BlockState blockState = simpleBlockConfiguration.toPlace().getState(context.random(), blockPos);
        if (blockState.canSurvive((LevelReader)worldGenLevel, blockPos)) {
            if (blockState.getBlock() instanceof DoublePlantBlock) {
                if (!worldGenLevel.isEmptyBlock(blockPos.above())) {
                    return false;
                }
                DoublePlantBlock.placeAt((LevelAccessor)worldGenLevel, (BlockState)blockState, (BlockPos)blockPos, (int)2);
            } else {
                worldGenLevel.setBlock(blockPos, blockState, 2);
            }
        } else {
            return false;
        }
        return true;
    }
}

