/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry;

import com.mojang.serialization.MapCodec;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.structure.GuardianFruitTreePiece;
import com.stevekung.fishofthieves.structure.GuardianFruitTreeStructure;
import com.stevekung.fishofthieves.structure.SeapostPieces;
import com.stevekung.fishofthieves.structure.SeapostStructure;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class FOTStructures {
    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter holderGetter = context.lookup(Registries.BIOME);
        context.register(Key.SEAPOST, (Object)new SeapostStructure(new Structure.StructureSettings.Builder((HolderSet)holderGetter.getOrThrow(FOTTags.Biomes.HAS_SEAPOST)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build()));
        context.register(Key.GUARDIAN_FRUIT_TREE, (Object)new GuardianFruitTreeStructure(0.85f, new Structure.StructureSettings.Builder((HolderSet)holderGetter.getOrThrow(BiomeTags.IS_DEEP_OCEAN)).terrainAdapation(TerrainAdjustment.BEARD_THIN).build()));
    }

    public static void init() {
        Type.init();
        PieceType.init();
    }

    public static interface Key {
        public static final ResourceKey<Structure> SEAPOST = Key.registerStructure("seapost");
        public static final ResourceKey<Structure> GUARDIAN_FRUIT_TREE = Key.registerStructure("guardian_fruit_tree");
        public static final ResourceKey<StructureSet> SEAPOSTS = Key.registerStructureSet("seapost");
        public static final ResourceKey<StructureSet> GUARDIAN_FRUIT_TREES = Key.registerStructureSet("guardian_fruit_trees");

        private static ResourceKey<Structure> registerStructure(String name) {
            return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)FishOfThieves.id(name));
        }

        private static ResourceKey<StructureSet> registerStructureSet(String name) {
            return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)FishOfThieves.id(name));
        }
    }

    public static interface Type {
        public static final StructureType<SeapostStructure> SEAPOST = Type.register("seapost", SeapostStructure.CODEC);
        public static final StructureType<GuardianFruitTreeStructure> GUARDIAN_FRUIT_TREE = Type.register("guardian_fruit_tree", GuardianFruitTreeStructure.CODEC);

        public static void init() {
            FishOfThieves.LOGGER.info("Registering Structure Type");
        }

        private static <S extends Structure> StructureType<S> register(String name, MapCodec<S> codec) {
            return (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)FishOfThieves.id(name), () -> codec);
        }
    }

    public static interface PieceType {
        public static final StructurePieceType SEAPOST_PIECE = PieceType.register("seapost", SeapostPieces.SeapostPiece::new);
        public static final StructurePieceType GUARDIAN_FRUIT_TREE_PIECE = PieceType.register("guardian_fruit_tree", GuardianFruitTreePiece::new);

        public static void init() {
            FishOfThieves.LOGGER.info("Registering Structure Piece Type");
        }

        private static StructurePieceType register(String pieceId, StructurePieceType.StructureTemplateType pieceType) {
            return (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)FishOfThieves.id(pieceId), (Object)pieceType);
        }
    }

    public static interface Sets {
        public static void bootstrap(BootstrapContext<StructureSet> context) {
            HolderGetter holderGetter = context.lookup(Registries.STRUCTURE);
            HolderGetter structureSetLookup = context.lookup(Registries.STRUCTURE_SET);
            context.register(Key.SEAPOSTS, (Object)new StructureSet(List.of(StructureSet.entry((Holder)holderGetter.getOrThrow(Key.SEAPOST))), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.LEGACY_TYPE_3, 0.6f, 26384127, Optional.of(new StructurePlacement.ExclusionZone((Holder)structureSetLookup.getOrThrow(BuiltinStructureSets.OCEAN_MONUMENTS), 8)), 64, 32, RandomSpreadType.LINEAR)));
            context.register(Key.GUARDIAN_FRUIT_TREES, (Object)new StructureSet(List.of(StructureSet.entry((Holder)holderGetter.getOrThrow(Key.GUARDIAN_FRUIT_TREE))), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.LEGACY_TYPE_3, 0.8f, 91579157, Optional.empty(), 64, 16, RandomSpreadType.LINEAR)));
        }
    }
}

