/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllConditionCheck;
import com.stevekung.fishofthieves.entity.condition.DayCheck;
import com.stevekung.fishofthieves.entity.condition.NightCheck;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCheck;
import com.stevekung.fishofthieves.entity.condition.RainingCheck;
import com.stevekung.fishofthieves.entity.condition.RandomChanceCheck;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCheck;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.MoonBrightnessCheck;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.level.biome.Biomes;

public class WreckerVariants {
    public static final ResourceKey<WreckerVariant> ROSE = WreckerVariants.createKey("rose");
    public static final ResourceKey<WreckerVariant> SUN = WreckerVariants.createKey("sun");
    public static final ResourceKey<WreckerVariant> BLACKCLOUD = WreckerVariants.createKey("blackcloud");
    public static final ResourceKey<WreckerVariant> SNOW = WreckerVariants.createKey("snow");
    public static final ResourceKey<WreckerVariant> MOON = WreckerVariants.createKey("moon");

    public static void bootstrap(BootstrapContext<WreckerVariant> context) {
        AbstractFishVariant.RegisterContext<WreckerVariant> registerContext = AbstractFishVariant.RegisterContext.create("wrecker", WreckerVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, ROSE, "rose", 0);
        registerContext.register(context, SUN, "sun", 1, true, AllConditionCheck.allOf(DayCheck.day(), SeeSkyCheck.seeSky()));
        registerContext.register(context, BLACKCLOUD, "blackcloud", 2, true, AllConditionCheck.allOf(RainingCheck.raining().thundering(true).build(), SeeSkyCheck.seeSky()));
        registerContext.register(context, SNOW, "snow", 3, true, registerContext.select(AllConditionCheck.allOf(new SpawnCondition[]{new BiomeCheck((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.FROZEN_OCEAN), biomeLookup.getOrThrow(Biomes.DEEP_FROZEN_OCEAN)})), RandomChanceCheck.chance(10)}), 1), registerContext.select(ProbabilityCheck.defaultRareProbablity(), 0));
        registerContext.register(context, MOON, "moon", 4, true, AllConditionCheck.allOf(new SpawnCondition[]{NightCheck.night(), SeeSkyCheck.seeSky(), new MoonBrightnessCheck(MinMaxBounds.Doubles.atMost((double)1.0))}));
    }

    public static void bootstrapSimple(BootstrapContext<WreckerVariant> context) {
        AbstractFishVariant.RegisterContext<WreckerVariant> registerContext = AbstractFishVariant.RegisterContext.create("wrecker", WreckerVariant::new);
        registerContext.register(context, ROSE, "rose", 0);
        registerContext.register(context, SUN, "sun", 1, true);
        registerContext.register(context, BLACKCLOUD, "blackcloud", 2, true);
        registerContext.register(context, SNOW, "snow", 3, true, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, MOON, "moon", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    private static ResourceKey<WreckerVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.WRECKER_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

