/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.structure;

import com.google.common.collect.Lists;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTStructures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class GuardianFruitTreePiece
extends TemplateStructurePiece {
    private float fruitChance;

    public GuardianFruitTreePiece(StructureTemplateManager structureTemplateManager, BlockPos templatePosition, ResourceLocation location, Rotation rotation, Mirror mirror, BlockPos pivotPos, float fruitChance) {
        super(FOTStructures.PieceType.GUARDIAN_FRUIT_TREE_PIECE, 0, structureTemplateManager, location, location.toString(), GuardianFruitTreePiece.makeSettings(mirror, rotation, pivotPos), templatePosition);
        this.fruitChance = fruitChance;
    }

    public GuardianFruitTreePiece(StructureTemplateManager structureTemplateManager, CompoundTag tag) {
        super(FOTStructures.PieceType.GUARDIAN_FRUIT_TREE_PIECE, tag, structureTemplateManager, resourceLocation -> GuardianFruitTreePiece.makeSettings(structureTemplateManager, tag, resourceLocation));
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        super.addAdditionalSaveData(context, tag);
        tag.putString("Rotation", this.placeSettings.getRotation().name());
        tag.putString("Mirror", this.placeSettings.getMirror().name());
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager structureTemplateManager, CompoundTag tag, ResourceLocation location) {
        StructureTemplate structureTemplate = structureTemplateManager.getOrCreate(location);
        BlockPos blockPos = new BlockPos(structureTemplate.getSize().getX() / 2, 0, structureTemplate.getSize().getZ() / 2);
        return GuardianFruitTreePiece.makeSettings((Mirror)tag.read("Mirror", Mirror.LEGACY_CODEC).orElseThrow(), (Rotation)tag.read("Rotation", Rotation.LEGACY_CODEC).orElseThrow(), blockPos);
    }

    private static StructurePlaceSettings makeSettings(Mirror mirror, Rotation rotation, BlockPos pos) {
        BlockIgnoreProcessor blockIgnoreProcessor = BlockIgnoreProcessor.STRUCTURE_BLOCK;
        ArrayList list = Lists.newArrayList();
        list.add(GuardianFruitTreePiece.getBlockReplaceRule(Blocks.PRISMARINE, 0.1f, (BlockState)FOTBlocks.PRISMARIZED_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z)));
        list.add(GuardianFruitTreePiece.getBlockReplaceRule(Blocks.PRISMARINE, 0.1f, (BlockState)FOTBlocks.PRISMARIZED_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X)));
        list.add(GuardianFruitTreePiece.getBlockReplaceRule(Blocks.PRISMARINE, 0.03f, Blocks.MAGMA_BLOCK));
        return new StructurePlaceSettings().setRotation(rotation).setMirror(mirror).setRotationPivot(pos).addProcessor((StructureProcessor)blockIgnoreProcessor).addProcessor((StructureProcessor)new RuleProcessor((List)list)).addProcessor((StructureProcessor)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE));
    }

    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        BoundingBox boundingBox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
        if (box.isInside((Vec3i)boundingBox.getCenter())) {
            box.encapsulate(boundingBox);
            super.postProcess(level, structureManager, generator, random, box, chunkPos, pos);
            this.spreadPrismarine(random, (LevelAccessor)level);
            this.addPrismarineDripColumnsBelow(random, (LevelAccessor)level);
        }
    }

    protected void handleDataMarker(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
        if (name.equals("guardian_fruit_block") && random.nextFloat() <= this.fruitChance) {
            level.setBlock(pos, FOTBlocks.GUARDIAN_FRUIT.defaultBlockState(), 2);
        }
    }

    private void addPrismarineDripColumnsBelow(RandomSource random, LevelAccessor level) {
        for (int i = this.boundingBox.minX() + 1; i < this.boundingBox.maxX(); ++i) {
            for (int j = this.boundingBox.minZ() + 1; j < this.boundingBox.maxZ(); ++j) {
                BlockPos blockPos = new BlockPos(i, this.boundingBox.minY(), j);
                if (!level.getBlockState(blockPos).is(Blocks.PRISMARINE)) continue;
                this.addPrismarineDripColumn(random, level, blockPos.below());
            }
        }
    }

    private void addPrismarineDripColumn(RandomSource random, LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        this.placeDecoratedBlocksOrMagma(random, level, (BlockPos)mutableBlockPos);
        for (int i = 8; i > 0 && random.nextFloat() < 0.5f; --i) {
            mutableBlockPos.move(Direction.DOWN);
            this.placeDecoratedBlocksOrMagma(random, level, (BlockPos)mutableBlockPos);
        }
    }

    private void spreadPrismarine(RandomSource random, LevelAccessor level) {
        BlockPos blockPos = this.boundingBox.getCenter();
        int i = blockPos.getX();
        int j = blockPos.getZ();
        float[] fs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k = fs.length;
        int l = (this.boundingBox.getXSpan() + this.boundingBox.getZSpan()) / 2;
        int m = random.nextInt(Math.max(1, 8 - l / 2));
        BlockPos.MutableBlockPos mutableBlockPos = BlockPos.ZERO.mutable();
        for (int o = i - k; o <= i + k; ++o) {
            for (int p = j - k; p <= j + k; ++p) {
                int q = Math.abs(o - i) + Math.abs(p - j);
                int r = Math.max(0, q + m);
                if (r >= k) continue;
                float f = fs[r];
                if (!(random.nextDouble() < (double)f)) continue;
                int s = GuardianFruitTreePiece.getSurfaceY(level, o, p);
                int t = Math.min(this.boundingBox.minY(), s);
                mutableBlockPos.set(o, t, p);
                if (Math.abs(t - this.boundingBox.minY()) > 3 || !this.canBlockBeReplaced(level, (BlockPos)mutableBlockPos)) continue;
                this.placeDecoratedBlocksOrMagma(random, level, (BlockPos)mutableBlockPos);
                this.addPrismarineDripColumn(random, level, mutableBlockPos.below());
            }
        }
    }

    private boolean canBlockBeReplaced(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        return !blockState.is(Blocks.AIR) && !blockState.is(BlockTags.FEATURES_CANNOT_REPLACE);
    }

    private void placeDecoratedBlocksOrMagma(RandomSource random, LevelAccessor level, BlockPos pos) {
        if (random.nextFloat() < 0.03f) {
            level.setBlock(pos, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
        } else if (random.nextFloat() < 0.1f) {
            level.setBlock(pos, (BlockState)FOTBlocks.PRISMARIZED_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)(random.nextBoolean() ? Direction.Axis.X : Direction.Axis.Z)), 3);
        } else {
            level.setBlock(pos, Blocks.PRISMARINE.defaultBlockState(), 3);
        }
    }

    private static int getSurfaceY(LevelAccessor level, int x, int z) {
        return level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, x, z) - 1;
    }

    private static ProcessorRule getBlockReplaceRule(Block block, float probability, Block replaceBlock) {
        return new ProcessorRule((RuleTest)new RandomBlockMatchTest(block, probability), (RuleTest)AlwaysTrueTest.INSTANCE, replaceBlock.defaultBlockState());
    }

    private static ProcessorRule getBlockReplaceRule(Block block, float probability, BlockState blockState) {
        return new ProcessorRule((RuleTest)new RandomBlockMatchTest(block, probability), (RuleTest)AlwaysTrueTest.INSTANCE, blockState);
    }
}

