/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.google.common.collect.BiMap;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.FishData;
import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public interface ThievesFish<T extends FishData>
extends PartyFish {
    public static final class_1856 WORMS = class_1856.method_8106(FOTTags.Items.WORMS);
    public static final class_1856 EARTHWORMS_FOOD = class_1856.method_8106(FOTTags.Items.EARTHWORMS_FOOD);
    public static final class_1856 GRUBS_FOOD = class_1856.method_8106(FOTTags.Items.GRUBS_FOOD);
    public static final class_1856 LEECHES_FOOD = class_1856.method_8106(FOTTags.Items.LEECHES_FOOD);
    public static final String VARIANT_TAG = "variant";
    public static final String TROPHY_TAG = "Trophy";
    public static final String HAS_FED_TAG = "HasFed";
    public static final String NO_FLIP_TAG = "NoFlip";

    public T getVariant();

    public void setVariant(T var1);

    public class_6880<T> getSpawnVariant(boolean var1);

    public class_2378<T> getRegistry();

    public BiMap<String, Integer> variantToCustomModelData();

    public boolean isTrophy();

    public void setTrophy(boolean var1);

    public boolean hasFed();

    public void setHasFed(boolean var1);

    public boolean isFood(class_1799 var1);

    public void setNoFlip(boolean var1);

    public boolean isNoFlip();

    default public float getGlowBrightness(float ageInTicks) {
        return 1.0f;
    }

    default public boolean isFishBreached(class_4095<?> brain) {
        return brain.method_18896(FOTMemoryModuleTypes.BREACHED_TICK) && (Integer)brain.method_18904(FOTMemoryModuleTypes.BREACHED_TICK).get() > 0;
    }

    default public void saveToBucket(class_2487 compound) {
        class_2960 variant = this.getRegistry().method_10221(this.getVariant());
        if (variant != null) {
            Integer customModelData;
            if (FishOfThieves.CONFIG.general.enableFishItemWithAllVariant && (customModelData = (Integer)this.variantToCustomModelData().get((Object)variant.toString())) > 0) {
                compound.method_10569("CustomModelData", customModelData.intValue());
            }
            compound.method_10582(VARIANT_TAG, variant.toString());
        }
        if (this.isTrophy()) {
            compound.method_10556(HAS_FED_TAG, this.hasFed());
            compound.method_10556(TROPHY_TAG, this.isTrophy());
        }
        if (this.isNoFlip()) {
            compound.method_10556(NO_FLIP_TAG, this.isNoFlip());
        }
    }

    default public void loadFromBucket(class_2487 compound) {
        FishData variant;
        if (compound.method_10545(VARIANT_TAG) && (variant = (FishData)this.getRegistry().method_10223(class_2960.method_12829((String)compound.method_10558(VARIANT_TAG)))) != null) {
            this.setVariant(variant);
        }
        if (compound.method_10545(TROPHY_TAG)) {
            this.setTrophy(compound.method_10577(TROPHY_TAG));
        }
        if (compound.method_10545(HAS_FED_TAG)) {
            this.setHasFed(compound.method_10577(HAS_FED_TAG));
        }
        if (compound.method_10545(NO_FLIP_TAG)) {
            this.setNoFlip(compound.method_10577(NO_FLIP_TAG));
        }
    }

    default public class_1315 defaultFinalizeSpawn(class_1309 livingEntity, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        if (reason == class_3730.field_16473 && dataTag != null && dataTag.method_10573(VARIANT_TAG, 8)) {
            FishData variant = (FishData)this.getRegistry().method_10223(class_2960.method_12829((String)dataTag.method_10558(VARIANT_TAG)));
            if (variant != null) {
                this.setVariant(variant);
            }
            this.setTrophy(dataTag.method_10577(TROPHY_TAG));
            return spawnData;
        }
        if (livingEntity.method_6051().method_43057() < FishOfThieves.CONFIG.spawnRate.trophyProbability) {
            this.setTrophy(true);
            livingEntity.method_6033(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.setVariant((FishData)this.getSpawnVariant(reason == class_3730.field_16473).comp_349());
        return spawnData;
    }

    default public class_6880<T> getSpawnVariant(class_1309 livingEntity, class_6862<T> tagKey, T defaultSpawn, boolean fromBucket) {
        return this.getRegistry().method_40266(tagKey).flatMap(named -> named.method_40243(livingEntity.method_6051())).filter(variant -> fromBucket || ((FishData)variant.comp_349()).getCondition().test(SpawnSelectors.get(livingEntity))).orElseGet(() -> class_6880.method_40223((Object)defaultSpawn));
    }
}

