/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.stevekung.fishofthieves.loot.predicate.StructureRangeCondition;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3518;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_6016;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record FOTLocationPredicate(class_6862<class_1959> biome, StructureRangeCondition structureRangeCondition, Continentalness continentalness, Boolean hasRaids) {
    public static final FOTLocationPredicate ANY = new FOTLocationPredicate(null, null, null, null);

    public boolean matches(class_3218 level, @Nullable class_1297 entity, double x, double y, double z) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        boolean loaded = level.method_8477(blockPos);
        boolean isRaided = level.method_19503(blockPos);
        return (this.biome == null || loaded && level.method_23753(blockPos).method_40220(this.biome)) && (this.structureRangeCondition == null || loaded && this.structureMatched(level, blockPos, entity, this.structureRangeCondition, (class_2378<class_3195>)level.method_30349().method_30530(class_7924.field_41246))) && (this.continentalness == null || loaded && this.continentalness == TerrainUtils.getContinentalness(level, blockPos)) && (this.hasRaids == null || loaded && this.hasRaids == isRaided);
    }

    private boolean structureMatched(class_3218 level, class_2338 blockPos, @Nullable class_1297 entity, StructureRangeCondition structureRangeCondition, class_2378<class_3195> structureRegistry) {
        Optional structureHolderSet = structureRegistry.method_40266(structureRangeCondition.structure());
        if (structureHolderSet.isPresent()) {
            for (class_6880 structureHolder : (class_6885.class_6888)structureHolderSet.get()) {
                class_3195 structure = (class_3195)structureHolder.comp_349();
                if (entity == null) {
                    return level.method_27056().method_38854(blockPos, structure).method_16657();
                }
                Iterator iterator = level.method_27056().method_38853(class_4076.method_18682((class_2338)blockPos), structure).iterator();
                if (!iterator.hasNext()) continue;
                class_3449 structureStart = (class_3449)iterator.next();
                return entity.method_5829().method_1014((double)structureRangeCondition.range().method_34997()).method_994(class_238.method_19316((class_3341)structureStart.method_14969()));
            }
        }
        return false;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.biome != null) {
            jsonObject.addProperty("biome", this.biome.comp_327().toString());
        }
        if (this.structureRangeCondition != null) {
            JsonObject jsonStructureObject = new JsonObject();
            jsonStructureObject.addProperty("structure", this.structureRangeCondition.structure().comp_327().toString());
            jsonStructureObject.addProperty("range", (Number)this.structureRangeCondition.range().method_34997());
            jsonObject.add("structure", (JsonElement)jsonStructureObject);
        }
        if (this.continentalness != null) {
            jsonObject.addProperty("continentalness", this.continentalness.method_15434());
        }
        if (this.hasRaids != null) {
            jsonObject.addProperty("hasRaids", this.hasRaids);
        }
        return jsonObject;
    }

    public static FOTLocationPredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonObject = class_3518.method_15295((JsonElement)json, (String)"location");
        class_6862 biome = null;
        StructureRangeCondition structureRangeCondition = null;
        Continentalness continentalness = null;
        Boolean hasRaids = null;
        if (jsonObject.has("biome")) {
            String string = class_3518.method_15265((JsonObject)jsonObject, (String)"biome");
            biome = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(string));
        }
        if (jsonObject.has("structure")) {
            JsonObject jsonStructureObject = class_3518.method_15281((JsonObject)jsonObject, (String)"structure", (JsonObject)new JsonObject());
            String structure = class_3518.method_15265((JsonObject)jsonStructureObject, (String)"structure");
            class_6016 range = class_6016.method_34998((int)class_3518.method_15260((JsonObject)jsonStructureObject, (String)"range"));
            structureRangeCondition = new StructureRangeCondition((class_6862<class_3195>)class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)new class_2960(structure)), range);
        }
        if (jsonObject.has("continentalness")) {
            continentalness = Continentalness.byName(class_3518.method_15265((JsonObject)jsonObject, (String)"continentalness"));
        }
        if (jsonObject.has("hasRaids")) {
            hasRaids = class_3518.method_15270((JsonObject)jsonObject, (String)"hasRaids");
        }
        return new FOTLocationPredicate((class_6862<class_1959>)biome, structureRangeCondition, continentalness, hasRaids);
    }

    public static class Builder {
        @Nullable
        private class_6862<class_1959> biome;
        @Nullable
        private StructureRangeCondition structureRangeCondition;
        @Nullable
        private Continentalness continentalness;
        @Nullable
        private Boolean hasRaids;

        public static Builder location() {
            return new Builder();
        }

        public Builder setBiome(@Nullable class_6862<class_1959> biome) {
            this.biome = biome;
            return this;
        }

        public Builder setStructureInRange(class_6862<class_3195> structure, int range) {
            this.structureRangeCondition = new StructureRangeCondition(structure, class_6016.method_34998((int)range));
            return this;
        }

        public Builder setContinentalness(@Nullable Continentalness continentalness) {
            this.continentalness = continentalness;
            return this;
        }

        public Builder hasRaids() {
            this.hasRaids = true;
            return this;
        }

        public FOTLocationPredicate build() {
            return new FOTLocationPredicate(this.biome, this.structureRangeCondition, this.continentalness, this.hasRaids);
        }
    }
}

