/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.AbstractBananaClusterBlock;
import com.stevekung.fishofthieves.block.BananaClusterBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaClusterPlantBlock
extends AbstractBananaClusterBlock
implements BonemealableBlock {
    public static final MapCodec<BananaClusterPlantBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BananaClusterBlock.Type.CODEC.fieldOf("type").forGetter(BananaClusterPlantBlock::getClusterType), (App)BananaClusterPlantBlock.propertiesCodec()).apply((Applicative)instance, BananaClusterPlantBlock::new));
    private static final Map<Direction, VoxelShape> SHAPES = Map.of(Direction.NORTH, Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0), Direction.WEST, Block.box((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0), Direction.SOUTH, Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0), Direction.EAST, Block.box((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0));
    public static final EnumProperty<HangingType> HANGING = EnumProperty.create((String)"hanging", HangingType.class);
    private final BananaClusterBlock.Type type;

    public BananaClusterPlantBlock(BananaClusterBlock.Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HANGING, (Comparable)((Object)HangingType.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.type != BananaClusterBlock.Type.RIPE;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.type == BananaClusterBlock.Type.BARELY_RIPE && BananaClusterBlock.canClusterPlantGrow((Level)level, pos) && random.nextInt(10) == 0) {
            level.setBlock(pos, FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.withPropertiesOf(state), 3);
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return state.is(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(6) == 0;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (this.type == BananaClusterBlock.Type.BARELY_RIPE) {
            level.setBlock(pos, FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.withPropertiesOf(state), 3);
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return new ItemStack((ItemLike)this.type.block().get());
    }

    @Override
    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (direction == Direction.UP && neighborState.is(FOTTags.Blocks.BANANA_CLUSTER_PLANTS)) {
            if (!neighborState.is(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT) && state.getValue(HANGING) == HangingType.SMALL_CLUSTER) {
                return (BlockState)state.setValue(HANGING, (Comparable)((Object)HangingType.NONE));
            }
            return state.getValue(HANGING) == HangingType.STEM || state.getValue(HANGING) == HangingType.SMALL_CLUSTER ? state : (BlockState)state.setValue(HANGING, (Comparable)((Object)HangingType.NONE));
        }
        return super.updateShape(state, level, scheduledTickAccess, currentPos, direction, neighborPos, neighborState, randomSource);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.is(FOTTags.Blocks.BANANA_CLUSTER_PLANTS) && !adjacentState.is(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT) && direction.getAxis().isVertical();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HANGING, WATERLOGGED});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BananaClusterBlock.Type getClusterType() {
        return this.type;
    }

    public static enum HangingType implements StringRepresentable
    {
        NONE,
        SMALL_CLUSTER,
        STEM;

        public static final StringRepresentable.EnumCodec<HangingType> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(HangingType::values);
        }
    }
}

