/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.FOTRotatedPillarBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class BuddingPrismarizedLogBlock
extends FOTRotatedPillarBlock
implements BonemealableBlock {
    public static final BooleanProperty BUD = BooleanProperty.create((String)"bud");

    public BuddingPrismarizedLogBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)BUD, (Comparable)Boolean.valueOf(false)));
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockState;
        if (random.nextInt(80) == 0 && BuddingPrismarizedLogBlock.canFruitGrowAtState(blockState = level.getBlockState(pos.below()))) {
            this.growGuardianFruit((Level)level, pos);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{BUD}));
    }

    public static boolean canFruitGrowAtState(BlockState state) {
        return state.is(Blocks.WATER) && state.getFluidState().getAmount() == 8;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return BuddingPrismarizedLogBlock.canFruitGrowAtState(level.getBlockState(pos.below()));
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(10) == 0;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growGuardianFruit((Level)level, pos);
    }

    private void growGuardianFruit(Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos.below(), FOTBlocks.GUARDIAN_FRUIT.defaultBlockState());
        level.playSound(null, pos, FOTSoundEvents.GUARDIAN_FRUIT_GROW, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }
}

