/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.serialization.MapCodec;
import com.stevekung.fishofthieves.block.VerticalLeavesBlock;
import com.stevekung.fishofthieves.client.AngledLeavesComponent;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.utils.CauldronUtils;
import com.stevekung.fishofthieves.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CoconutFrondsBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<CoconutFrondsBlock> CODEC = CoconutFrondsBlock.simpleCodec(CoconutFrondsBlock::new);
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape BASE = Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape NOT_MIDDLE = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public CoconutFrondsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)Part.SINGLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isRainingAt(pos.above()) && state.getValue(PART) == Part.TAIL && random.nextFloat() < 0.2f) {
            CauldronUtils.fillCauldronFromLeavesTail(state, level, pos);
        }
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        BlockState otherState = level.getBlockState(pos.relative((Direction)state.getValue((Property)FACING)));
        return otherState.canBeReplaced();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        FluidState fluidState = level.getFluidState(pos.relative((Direction)state.getValue((Property)FACING)));
        level.setBlock(pos.relative((Direction)state.getValue((Property)FACING)), (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)Part.TAIL))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER)), 3);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        BlockState otherState = level.getBlockState(currentPos.relative((Direction)state.getValue((Property)FACING)));
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        switch (((Part)((Object)state.getValue(PART))).ordinal()) {
            case 0: {
                if (!otherState.is((Block)this) || otherState.getValue((Property)FACING) != state.getValue((Property)FACING)) break;
                return (BlockState)state.setValue(PART, (Comparable)((Object)Part.STEM));
            }
            case 1: {
                if (otherState.is((Block)this)) break;
                return (BlockState)state.setValue(PART, (Comparable)((Object)Part.SINGLE));
            }
            case 2: {
                if (otherState.is((Block)this)) break;
                return (BlockState)state.setValue(PART, (Comparable)((Object)Part.TAIL));
            }
            case 3: {
                if (!otherState.is((Block)this) || otherState.getValue((Property)FACING) != state.getValue((Property)FACING) || otherState.getValue(PART) != Part.TAIL) break;
                return (BlockState)state.setValue(PART, (Comparable)((Object)Part.MIDDLE));
            }
        }
        return state.canSurvive(level, currentPos) ? super.updateShape(state, level, scheduledTickAccess, currentPos, direction, neighborPos, neighborState, randomSource) : Blocks.AIR.defaultBlockState();
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState otherState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        if (otherState.is((Block)this)) {
            return state.getValue((Property)FACING) == otherState.getValue((Property)FACING);
        }
        return otherState.is(FOTTags.Blocks.COCONUT_LOGS) || otherState.is(FOTTags.Blocks.SMALL_COCONUT_LOGS) || otherState.is(BlockTags.LEAVES) && otherState.isCollisionShapeFullBlock((BlockGetter)level, pos) || otherState.isFaceSturdy((BlockGetter)level, pos, (Direction)state.getValue((Property)FACING));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.isRainingAt(pos.above()) && random.nextInt(8) == 0) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            switch (((Part)((Object)state.getValue(PART))).ordinal()) {
                case 2: {
                    BlockPos blockPos = pos.below();
                    BlockState blockState = level.getBlockState(blockPos);
                    if (blockState.canOcclude() && blockState.isFaceSturdy((BlockGetter)level, blockPos, Direction.UP)) break;
                    double x = (double)pos.getX() + random.nextDouble();
                    double y = (double)pos.getY() + 0.75;
                    double z = (double)pos.getZ() + random.nextDouble();
                    level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, x, y, z, 0.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    AngledLeavesComponent component = new AngledLeavesComponent(-22.5, 1.0, 0.0);
                    ParticleUtils.spawnDrippingWaterParticlesForLeaves(level, direction, pos, random, UniformInt.of((int)2, (int)6), 0.3, 2, true, true, component);
                    break;
                }
                case 0: {
                    AngledLeavesComponent component = new AngledLeavesComponent(-22.5, 1.0, 30.0);
                    ParticleUtils.spawnDrippingWaterParticlesForLeaves(level, direction, pos, random, UniformInt.of((int)2, (int)6), -0.1, 2, false, true, component);
                    break;
                }
                case 3: {
                    AngledLeavesComponent component = new AngledLeavesComponent(22.5, 0.9, 35.0);
                    ParticleUtils.spawnDrippingWaterParticlesForLeaves(level, direction, pos, random, UniformInt.of((int)2, (int)8), 0.25, 4, false, true, component);
                }
            }
        }
    }

    private BlockState placeVerticalLeaves(Direction direction, boolean isWater) {
        BlockState blockState = (BlockState)FOTBlocks.VERTICAL_COCONUT_FRONDS.defaultBlockState().setValue((Property)VerticalLeavesBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
        return direction == Direction.DOWN ? (BlockState)blockState.setValue((Property)VerticalLeavesBlock.CEILING, (Comparable)Boolean.valueOf(true)) : blockState;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean isWater;
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        Direction direction = context.getClickedFace();
        boolean bl = isWater = fluidState.getType() == Fluids.WATER;
        if (direction.getAxis() == Direction.Axis.Y) {
            return this.placeVerticalLeaves(direction, isWater);
        }
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        BlockState otherState = context.getLevel().getBlockState(context.getClickedPos().relative(((Direction)blockState.getValue((Property)FACING)).getOpposite()));
        if (otherState.is((Block)this) && (otherState.getValue(PART) == Part.SINGLE || otherState.getValue(PART) == Part.TAIL)) {
            blockState = (BlockState)blockState.setValue(PART, (Comparable)((Object)Part.TAIL));
        }
        if (blockState.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
            return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(PART) != Part.MIDDLE) {
            return NOT_MIDDLE;
        }
        return BASE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, WATERLOGGED});
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public static enum Part implements StringRepresentable
    {
        SINGLE("single"),
        STEM("stem"),
        MIDDLE("middle"),
        TAIL("tail");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

