/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.api.block.fish_plaque.FishPlaqueInteraction;
import com.stevekung.fishofthieves.blockentity.FishPlaqueBlockEntity;
import com.stevekung.fishofthieves.entity.BucketableEntityType;
import com.stevekung.fishofthieves.registry.FOTBlockEntityTypes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FishPlaqueBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private final Map<Direction, VoxelShape> aabb;
    private final Type type;
    public static final MapCodec<FishPlaqueBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FishPlaqueBlock.propertiesCodec(), (App)Type.CODEC.fieldOf("type").forGetter(FishPlaqueBlock::getType)).apply((Applicative)instance, FishPlaqueBlock::new));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)1, (int)8);

    public FishPlaqueBlock(BlockBehaviour.Properties properties, Type type) {
        super(properties);
        this.type = type;
        this.aabb = type.aabb;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ROTATION, (Comparable)Integer.valueOf(1)));
    }

    public Type getType() {
        return this.type;
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        if (this.type == Type.WOODEN) {
            return false;
        }
        if (this.type == Type.GILDED) {
            return direction.getAxis().isVertical() && adjacentState.isSolid() || direction.getAxis().isHorizontal() && adjacentState.is((Block)this);
        }
        return adjacentState.is((Block)this) || super.skipRendering(state, adjacentState, direction);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FishPlaqueBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.aabb.get(state.getValue(FACING));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = itemStack.getItem();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof FishPlaqueBlockEntity)) return InteractionResult.PASS;
        FishPlaqueBlockEntity fishPlaque = (FishPlaqueBlockEntity)blockEntity;
        if (itemStack.is(FOTTags.Items.FISH_PLAQUE_BUCKET_BLACKLIST)) {
            return InteractionResult.PASS;
        }
        if (fishPlaque.hasPlaqueData()) {
            Entity entity = FishPlaqueBlockEntity.createEntity(fishPlaque, level);
            Optional<FishPlaqueInteraction> interactionOptional = level.registryAccess().lookupOrThrow(FOTRegistries.FISH_PLAQUE_INTERACTION).listElements().map(Holder.Reference::value).filter(interaction -> fishPlaque.getEntityKeyFromPlaqueData().equals(interaction.entityType().toString())).findFirst();
            if (itemStack.is(interactionOptional.map(interaction -> (Item)BuiltInRegistries.ITEM.getValue(interaction.item())).orElse(Items.WATER_BUCKET)) && !fishPlaque.isWaxed()) {
                if (!(entity instanceof Bucketable)) return InteractionResult.PASS;
                Bucketable bucketable = (Bucketable)entity;
                ItemStack itemStack2 = bucketable.getBucketItemStack();
                bucketable.saveToBucketTag(itemStack2);
                level.playSound((Entity)player, pos, bucketable.getPickupSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ItemStack itemStack3 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)itemStack2, (boolean)false);
                player.setItemInHand(hand, itemStack3);
                fishPlaque.clearDisplayEntity();
                blockEntity.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return InteractionResult.SUCCESS;
            }
            if (fishPlaque.isWaxed()) {
                if (!(item instanceof AxeItem)) return InteractionResult.PASS;
                fishPlaque.setWaxed(false);
                blockEntity.setChanged();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, itemStack);
                }
                level.playSound((Entity)player, pos, FOTSoundEvents.FISH_PLAQUE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.levelEvent((Entity)player, 3004, pos, 0);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                return InteractionResult.SUCCESS;
            }
            if (item == Items.HONEYCOMB) {
                fishPlaque.setWaxed(true);
                blockEntity.setChanged();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, itemStack);
                }
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                }
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
                level.levelEvent((Entity)player, 3003, pos, 0);
                return InteractionResult.SUCCESS;
            }
            level.playSound((Entity)player, pos, FOTSoundEvents.FISH_PLAQUE_ROTATE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            level.setBlock(pos, FishPlaqueBlock.cycleRotation(state, player.isSecondaryUseActive()), 3);
            return InteractionResult.SUCCESS;
        }
        if (!(item instanceof MobBucketItem)) return InteractionResult.PASS;
        MobBucketItem bucket = (MobBucketItem)item;
        CompoundTag tag = new CompoundTag();
        EntityType entityType = bucket.type;
        String entityKey = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType).toString();
        Optional<FishPlaqueInteraction> interactionOptional = level.registryAccess().lookupOrThrow(FOTRegistries.FISH_PLAQUE_INTERACTION).listElements().map(Holder.Reference::value).filter(interaction -> BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType).equals((Object)interaction.entityType())).findFirst();
        tag.putString("id", entityKey);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entityToSave = ((BucketableEntityType)entityType).fishofthieves$spawnByBucket(serverLevel, itemStack, null, EntitySpawnReason.BUCKET);
            if (entityToSave instanceof Bucketable) {
                Bucketable bucketable = (Bucketable)entityToSave;
                CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
                bucketable.loadFromBucketTag(customData.copyTag());
            }
            entityToSave.saveWithoutId(tag);
            entityToSave.snapTo(pos, 0.0f, 0.0f);
            entityToSave.discard();
            fishPlaque.setPlaqueData(tag);
        }
        level.playSound((Entity)player, pos, bucket.emptySound, SoundSource.BLOCKS, 1.0f, 1.0f);
        blockEntity.setChanged();
        level.sendBlockUpdated(pos, state, state, 3);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
        if (!player.getAbilities().instabuild) {
            player.setItemInHand(hand, new ItemStack((ItemLike)interactionOptional.map(interaction -> (Item)BuiltInRegistries.ITEM.getValue(interaction.item())).orElse(Items.WATER_BUCKET)));
        }
        if (level.isClientSide()) return InteractionResult.SUCCESS;
        player.awardStat(Stats.ITEM_USED.get((Object)item));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return FishPlaqueBlock.createTickerHelper(blockEntityType, FOTBlockEntityTypes.FISH_PLAQUE, FishPlaqueBlockEntity::animation);
        }
        return null;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction[] directions;
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(blockPos)));
        FluidState fluidState = context.getLevel().getFluidState(blockPos);
        Level levelReader = context.getLevel();
        for (Direction direction : directions = context.getNearestLookingDirections()) {
            Direction direction2;
            if (!direction.getAxis().isHorizontal() || !(blockState = (BlockState)blockState.setValue(FACING, (Comparable)(direction2 = direction.getOpposite()))).canSurvive((LevelReader)levelReader, blockPos)) continue;
            return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue(FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = level.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)level, blockPos, direction);
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FishPlaqueBlockEntity) {
            level.updateNeighbourForOutputSignal(pos, state.getBlock());
        }
        super.affectNeighborsAfterRemoval(state, level, pos, isMoving);
    }

    public void spawnAfterBreak(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean dropExperience) {
        super.spawnAfterBreak(state, level, pos, stack, dropExperience);
        this.spawnFish(state, (Level)level, pos, level.getBlockEntity(pos));
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (!level.isClientSide()) {
            this.spawnFish(state, level, pos, blockEntity);
        }
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return direction.getOpposite() == state.getValue(FACING) && !state.canSurvive(level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, scheduledTickAccess, currentPos, direction, neighborPos, neighborState, randomSource);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isPossibleToRespawnInThis(BlockState blockState) {
        return true;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        FishPlaqueBlockEntity fishPlaque;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FishPlaqueBlockEntity && (fishPlaque = (FishPlaqueBlockEntity)blockEntity).hasPlaqueData()) {
            return (Integer)state.getValue((Property)ROTATION);
        }
        return 0;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        boolean hasSignal;
        if (!level.isClientSide() && (hasSignal = level.hasNeighborSignal(pos)) != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasSignal)), 2);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, ROTATION, POWERED});
    }

    private void spawnFish(BlockState state, Level level, BlockPos pos, BlockEntity blockEntity) {
        FishPlaqueBlockEntity fishPlaque;
        if (blockEntity instanceof FishPlaqueBlockEntity && (fishPlaque = (FishPlaqueBlockEntity)blockEntity).hasPlaqueData()) {
            Entity entity = FishPlaqueBlockEntity.createEntity(fishPlaque, level);
            Direction direction = (Direction)state.getValue(FACING);
            double random = level.random.nextDouble() * 0.1 + 0.2;
            if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                entity.setAirSupply(100);
            }
            entity.snapTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, direction.toYRot(), 0.0f);
            entity.setDeltaMovement(level.random.triangle((double)direction.getStepX() * random, 0.0172275), 0.4, level.random.triangle((double)direction.getStepZ() * random, 0.0172275));
            level.addFreshEntity(entity);
        }
    }

    private static BlockState cycleRotation(BlockState state, boolean backwards) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)FishPlaqueBlock.getRelative(ROTATION.getPossibleValues(), (Integer)state.getValue((Property)ROTATION), backwards));
    }

    private static <T> T getRelative(Iterable<T> allowedValues, @Nullable T currentValue, boolean backwards) {
        return (T)(backwards ? Util.findPreviousInIterable(allowedValues, currentValue) : Util.findNextInIterable(allowedValues, currentValue));
    }

    public static enum Type implements StringRepresentable
    {
        WOODEN(Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)16.0), (Object)Direction.WEST, (Object)Block.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)))),
        IRON(Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), (Object)Direction.WEST, (Object)Block.box((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)))),
        GOLDEN(Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), (Object)Direction.WEST, (Object)Block.box((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)))),
        GILDED(Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.join((VoxelShape)Block.box((double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)13.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.OR), (Object)Direction.SOUTH, (Object)Shapes.join((VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), (VoxelShape)Block.box((double)1.0, (double)13.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0), (BooleanOp)BooleanOp.OR), (Object)Direction.EAST, (Object)Shapes.join((VoxelShape)Block.box((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)13.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.OR), (Object)Direction.WEST, (Object)Shapes.join((VoxelShape)Block.box((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (VoxelShape)Block.box((double)14.0, (double)13.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.OR))));

        private final Map<Direction, VoxelShape> aabb;
        public static final StringRepresentable.EnumCodec<Type> CODEC;

        private Type(Map<Direction, VoxelShape> aabb) {
            this.aabb = aabb;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

