/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.blockentity;

import com.stevekung.fishofthieves.block.FishPlaqueBlock;
import com.stevekung.fishofthieves.registry.FOTBlockEntityTypes;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FishPlaqueBlockEntity
extends BlockEntity {
    public static final String PLAQUE_DATA_TAG = "PlaqueData";
    public static final String WAXED_TAG = "Waxed";
    private boolean waxed;
    private int animationTickCount;
    private boolean isAnimating;
    @Nullable
    private Entity displayEntity;
    @Nullable
    private CompoundTag plaqueData;

    public FishPlaqueBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(FOTBlockEntityTypes.FISH_PLAQUE, blockPos, blockState);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.setPlaqueData(tag.getCompoundOrEmpty(PLAQUE_DATA_TAG));
        this.waxed = tag.getBooleanOr(WAXED_TAG, false);
        this.displayEntity = null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (this.plaqueData != null) {
            tag.put(PLAQUE_DATA_TAG, (Tag)this.plaqueData);
        }
        tag.putBoolean(WAXED_TAG, this.waxed);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        this.displayEntity = null;
        return this.saveWithoutMetadata(provider);
    }

    public void setPlaqueData(CompoundTag plaqueData) {
        this.plaqueData = plaqueData;
    }

    @Nullable
    public CompoundTag getPlaqueData() {
        return this.plaqueData;
    }

    public boolean hasPlaqueData() {
        return this.plaqueData != null && this.plaqueData.contains("id");
    }

    public void setWaxed(boolean waxed) {
        this.waxed = waxed;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public String getEntityKeyFromPlaqueData() {
        return (String)this.plaqueData.getString("id").orElseThrow();
    }

    public void clearDisplayEntity() {
        this.plaqueData = null;
        this.displayEntity = null;
    }

    public static void animation(Level level, BlockPos pos, BlockState state, FishPlaqueBlockEntity blockEntity) {
        if (state.hasProperty((Property)FishPlaqueBlock.POWERED) && ((Boolean)state.getValue((Property)FishPlaqueBlock.POWERED)).booleanValue()) {
            blockEntity.isAnimating = true;
            ++blockEntity.animationTickCount;
        } else {
            blockEntity.isAnimating = false;
        }
    }

    public float getAnimation(float partialTick) {
        return this.isAnimating ? (float)this.animationTickCount + partialTick : (float)this.animationTickCount;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level level) {
        if (!this.hasPlaqueData()) {
            return null;
        }
        if (this.displayEntity == null) {
            this.displayEntity = FishPlaqueBlockEntity.createEntity(this, level);
        }
        return this.displayEntity;
    }

    @Nullable
    public static Entity createEntity(FishPlaqueBlockEntity blockEntity, Level level) {
        return EntityType.loadEntityRecursive((CompoundTag)blockEntity.getPlaqueData(), (Level)level, (EntitySpawnReason)EntitySpawnReason.LOAD, Function.identity());
    }
}

