/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.stevekung.fishofthieves.FishOfThieves;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PufferfishRenderState;
import net.minecraft.client.renderer.entity.state.TropicalFishRenderState;
import net.minecraft.world.entity.animal.TropicalFish;

public class HeadphoneModel<S extends EntityRenderState>
extends EntityModel<S> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("headphone"), "main");

    public HeadphoneModel(ModelPart part) {
        super(part);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("headphone", CubeListBuilder.create().texOffs(0, 3).addBox(1.5f, -7.5f, -1.0f, 1.0f, 2.0f, 2.0f).texOffs(0, 3).addBox(-2.5f, -7.5f, -1.0f, 1.0f, 2.0f, 2.0f).texOffs(0, 0).addBox(-2.0f, -9.5f, -0.5f, 4.0f, 2.0f, 1.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)16, (int)16);
    }

    public void setupAnim(S renderState) {
    }

    public static interface Scaleable<S extends LivingEntityRenderState> {
        public static final Scaleable<LivingEntityRenderState> COD = (entity, poseStack) -> poseStack.translate(0.0f, 0.25f, -0.05f);
        public static final Scaleable<LivingEntityRenderState> SALMON = (entity, poseStack) -> {
            poseStack.scale(1.5f, 1.5f, 1.5f);
            poseStack.translate(0.0f, -0.275f, 0.0f);
        };
        public static final Scaleable<PufferfishRenderState> PUFFERFISH = (renderState, poseStack) -> {
            float y = 0.0f;
            switch (renderState.puffState) {
                case 0: {
                    y = 0.25f;
                    poseStack.scale(1.25f, 1.0f, 0.75f);
                    break;
                }
                case 1: {
                    y = -0.275f;
                    poseStack.scale(1.75f, 1.5f, 1.5f);
                    break;
                }
                case 2: {
                    y = -0.55f;
                    poseStack.scale(3.0f, 2.0f, 2.0f);
                }
            }
            poseStack.translate(0.0f, y, -0.025f);
        };
        public static final Scaleable<TropicalFishRenderState> TROPICAL_FISH = (renderState, poseStack) -> {
            TropicalFish.Base baseVariant = renderState.pattern.base();
            float y = 0.0f;
            float z = 0.0f;
            if (baseVariant == TropicalFish.Base.SMALL) {
                y = 0.275f;
                z = -0.08f;
            } else {
                y = -0.325f;
                z = -0.1f;
                poseStack.scale(1.0f, 1.5f, 1.0f);
            }
            poseStack.translate(0.0f, y, z);
        };
        public static final Scaleable<LivingEntityRenderState> TADPOLE = (entity, poseStack) -> {
            poseStack.scale(1.1f, 1.1f, 1.1f);
            poseStack.translate(0.0f, 0.15f, -0.08f);
        };

        public void scale(S var1, PoseStack var2);
    }
}

