/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.renderer.entity.state.ThievesFishRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class SplashtailModel<S extends ThievesFishRenderState>
extends EntityModel<S>
implements HeadphoneModel.Scaleable<S> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("splashtail"), "main");
    private final ModelPart main;
    private final ModelPart body_back;

    public SplashtailModel(ModelPart part) {
        super(part, RenderType::entityCutout);
        this.main = part.getChild("main");
        this.body_back = this.main.getChild("body_back");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition main = partDefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = main.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(16, 0).addBox(-1.5f, 0.75f, -4.3f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.05f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.75f, (float)-4.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -2.25f, -4.25f, 3.0f, 3.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-3.75f, (float)-4.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition body_main = main.addOrReplaceChild("body_main", CubeListBuilder.create().texOffs(0, 8).addBox(-1.5f, -6.25f, -3.5f, 3.0f, 5.0f, 6.0f, new CubeDeformation(0.01f)).texOffs(20, 14).addBox(0.0f, -8.25f, -0.5f, 0.0f, 2.0f, 3.0f, CubeDeformation.NONE).texOffs(20, 10).addBox(0.0f, -1.25f, -2.5f, 0.0f, 1.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body_main.addOrReplaceChild("right_fin_r1", CubeListBuilder.create().texOffs(20, 22).addBox(-2.25f, -4.25f, -3.0f, 3.0f, 3.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.5f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        body_main.addOrReplaceChild("left_fin_r1", CubeListBuilder.create().texOffs(20, 19).addBox(-0.75f, -4.25f, -3.0f, 3.0f, 3.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.5f, (float)0.0f, (float)0.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition body_back = main.addOrReplaceChild("body_back", CubeListBuilder.create().texOffs(0, 19).addBox(-1.5f, -1.75f, 0.0f, 3.0f, 4.0f, 6.0f, CubeDeformation.NONE).texOffs(16, 6).addBox(-1.5f, -2.5f, -0.25f, 3.0f, 1.0f, 5.0f, new CubeDeformation(-0.2f)).texOffs(20, 6).addBox(0.0f, -5.25f, 0.0f, 0.0f, 4.0f, 6.0f, CubeDeformation.NONE).texOffs(20, 20).addBox(0.0f, -2.25f, 6.0f, 0.0f, 5.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-3.5f, (float)2.5f));
        body_back.addOrReplaceChild("right_fin_r2", CubeListBuilder.create().texOffs(26, 16).addBox(1.125f, 1.95f, 5.0f, 0.0f, 2.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.0f, (float)-0.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.5236f));
        body_back.addOrReplaceChild("left_fin_r2", CubeListBuilder.create().texOffs(26, 14).addBox(-1.125f, 1.95f, 5.0f, 0.0f, 2.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)-0.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void setupAnim(S renderState) {
        float backRotation = 1.0f;
        float backRotSpeed = 1.0f;
        if (!((ThievesFishRenderState)((Object)renderState)).isInWater && !((ThievesFishRenderState)((Object)renderState)).isNoFlip) {
            backRotation = 1.5f;
            backRotSpeed = 1.7f;
        }
        this.body_back.yRot = -backRotation * 0.2f * Mth.sin((float)(backRotSpeed * 0.6f * ((ThievesFishRenderState)((Object)renderState)).ageInTicks));
    }

    @Override
    public void scale(S renderState, PoseStack poseStack) {
        float scale = 1.5f;
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0f, -0.275f, -0.075f);
    }
}

