/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class FishBreaching<E extends LivingEntity>
extends Behavior<E> {
    private static final int[] STEPS_TO_CHECK = new int[]{1, 2, 3};
    private final float jumpVelocity;
    private final float horizontalVelocity;
    private final UniformInt chance;

    public FishBreaching(UniformInt chance, float jumpVelocity, float horizontalVelocity) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT, FOTMemoryModuleTypes.BREACHED_TICK, (Object)MemoryStatus.REGISTERED));
        this.jumpVelocity = jumpVelocity;
        this.horizontalVelocity = horizontalVelocity;
        this.chance = chance;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        int[] nArray;
        int n;
        int n2;
        Direction direction = owner.getMotionDirection();
        int stepX = direction.getStepX();
        int stepZ = direction.getStepZ();
        BlockPos blockPos = owner.blockPosition();
        boolean inWater = owner.isInWater();
        if (!inWater) {
            owner.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)this.chance.sample(level.random));
        }
        if ((n2 = 0) < (n = (nArray = STEPS_TO_CHECK).length)) {
            int scale = nArray[n2];
            boolean isClear = !this.waterIsClear(owner, blockPos, stepX, stepZ, scale) || !this.surfaceIsClear(owner, blockPos, stepX, stepZ, scale);
            return inWater && !isClear;
        }
        return false;
    }

    protected void start(ServerLevel level, E entity, long gameTime) {
        Direction direction = entity.getMotionDirection();
        entity.playSound(FOTSoundEvents.FISH_JUMP);
        entity.setDeltaMovement(entity.getDeltaMovement().add((double)((float)direction.getStepX() * this.horizontalVelocity), (double)this.jumpVelocity, (double)((float)direction.getStepZ() * this.horizontalVelocity)));
        entity.getBrain().setMemory(FOTMemoryModuleTypes.BREACHED_TICK, (Object)20);
    }

    protected void stop(ServerLevel level, E entity, long gameTime) {
        entity.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)this.chance.sample(level.random));
    }

    protected void tick(ServerLevel level, E owner, long gameTime) {
        Vec3 vec3 = owner.getDeltaMovement();
        if (vec3.y * vec3.y < (double)0.03f && owner.getXRot() != 0.0f) {
            owner.setXRot(Mth.rotLerp((float)0.2f, (float)owner.getXRot(), (float)0.0f));
        } else if (vec3.length() > (double)1.0E-5f) {
            double d = vec3.horizontalDistance();
            double e = Math.atan2(-vec3.y, d) * 180.0 / 3.1415927410125732;
            owner.setXRot((float)e);
        }
    }

    private boolean waterIsClear(E entity, BlockPos blockPos, int dx, int dz, int scale) {
        blockPos = blockPos.offset(dx * scale, 0, dz * scale);
        return entity.level().getFluidState(blockPos).is(FluidTags.WATER) && !entity.level().getBlockState(blockPos).blocksMotion();
    }

    private boolean surfaceIsClear(E entity, BlockPos blockPos, int dx, int dz, int scale) {
        return entity.level().getBlockState(blockPos.offset(dx * scale, 1, dz * scale)).isAir() && entity.level().getBlockState(blockPos.offset(dx * scale, 2, dz * scale)).isAir();
    }
}

