/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class StartAttackingIgnoreFlockLeader<E extends Mob>
extends Behavior<E> {
    private final Predicate<E> canAttackPredicate;
    private final Function<E, Optional<? extends LivingEntity>> targetFinderFunction;

    public StartAttackingIgnoreFlockLeader(Predicate<E> canAttackPredicate, Function<E, Optional<? extends LivingEntity>> targetFinderFunction) {
        this(canAttackPredicate, targetFinderFunction, 60);
    }

    public StartAttackingIgnoreFlockLeader(Predicate<E> canAttackPredicate, Function<E, Optional<? extends LivingEntity>> targetFinderFunction, int i) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryStatus.REGISTERED, FOTMemoryModuleTypes.FLOCK_LEADER, (Object)MemoryStatus.REGISTERED), i);
        this.canAttackPredicate = canAttackPredicate;
        this.targetFinderFunction = targetFinderFunction;
    }

    public StartAttackingIgnoreFlockLeader(Function<E, Optional<? extends LivingEntity>> targetFinderFunction) {
        this(mob -> true, targetFinderFunction);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        if (!this.canAttackPredicate.test(owner)) {
            return false;
        }
        Optional<? extends LivingEntity> optional = this.targetFinderFunction.apply(owner);
        return optional.isPresent() && owner.canAttack(optional.get());
    }

    protected void start(ServerLevel level, E entity, long gameTime) {
        this.targetFinderFunction.apply(entity).ifPresent(livingEntity -> StartAttackingIgnoreFlockLeader.setAttackTarget(entity, livingEntity));
    }

    public static <E extends Mob> void setAttackTarget(E mob, LivingEntity attackTarget) {
        Brain brain = mob.getBrain();
        brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)attackTarget);
        brain.eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        brain.getMemory(FOTMemoryModuleTypes.FLOCK_LEADER).ifPresent(AbstractFlockFish::removeFollower);
        brain.eraseMemory(FOTMemoryModuleTypes.FLOCK_LEADER);
    }
}

