/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.ai.BattlegillAi;
import com.stevekung.fishofthieves.entity.variant.BattlegillVariant;
import com.stevekung.fishofthieves.registry.FOTDataComponentTypes;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.BattlegillVariants;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class Battlegill
extends AbstractSchoolingThievesFish<BattlegillVariant> {
    private static final EntityDataAccessor<Holder<BattlegillVariant>> VARIANT = SynchedEntityData.defineId(Battlegill.class, FOTDataSerializers.BATTLEGILL_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:jade", (Object)0);
        map.put((Object)"fishofthieves:sky", (Object)1);
        map.put((Object)"fishofthieves:rum", (Object)2);
        map.put((Object)"fishofthieves:sand", (Object)3);
        map.put((Object)"fishofthieves:bittersweet", (Object)4);
    });
    private static final ImmutableList<SensorType<? extends Sensor<? super Battlegill>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, (Object)SensorType.HURT_BY, FOTSensorTypes.NEAREST_SCHOOLING_THIEVES_FISH, FOTSensorTypes.GRUBS_THIEVES_FISH_TEMPTATIONS, FOTSensorTypes.NEAREST_MAGMA_BLOCK, FOTSensorTypes.BATTLEGILL_ATTACKABLES);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.NEAREST_REPELLENT, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, FOTMemoryModuleTypes.SCHOOL_SIZE, FOTMemoryModuleTypes.FLOCK_LEADER, (Object[])new MemoryModuleType[]{FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH, FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, FOTMemoryModuleTypes.BREACHED_TICK});

    public Battlegill(EntityType<? extends Battlegill> entityType, Level level) {
        super(entityType, level, FOTRegistries.BATTLEGILL_VARIANT, BattlegillVariants.JADE, FOTDataComponentTypes.BATTLEGILL_VARIANT);
    }

    protected Brain.Provider<Battlegill> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return BattlegillAi.makeBrain((Brain<Battlegill>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Battlegill> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(ServerLevel serverLevel) {
        ProfilerFiller profiler = Profiler.get();
        profiler.push("battlegillBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.popPush("battlegillActivityUpdate");
        BattlegillAi.updateActivity(this);
        profiler.pop();
        super.customServerAiStep(serverLevel);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.registryAccess().lookupOrThrow(FOTRegistries.BATTLEGILL_VARIANT).getOrThrow(BattlegillVariants.JADE));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        BattlegillAi.initMemories(this);
    }

    @Override
    public Holder<BattlegillVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    @Override
    public void setVariant(Holder<BattlegillVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)FOTItems.BATTLEGILL_BUCKET);
    }

    protected SoundEvent getDeathSound() {
        return FOTSoundEvents.BATTLEGILL_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return FOTSoundEvents.BATTLEGILL_HURT;
    }

    protected SoundEvent getFlopSound() {
        return FOTSoundEvents.BATTLEGILL_FLOP;
    }

    public int getMaxSchoolSize() {
        return 4;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isTrophy() ? super.getDefaultDimensions(pose).withEyeHeight(0.3f) : EntityDimensions.fixed((float)0.275f, (float)0.275f).withEyeHeight(0.14f);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason entitySpawnReason, @Nullable SpawnGroupData spawnGroupData) {
        if (this.isTrophy()) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2.0);
        }
        return super.finalizeSpawn(level, difficulty, entitySpawnReason, spawnGroupData);
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2.0);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(GRUBS_FOOD);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, EntitySpawnReason entitySpawnReason, BlockPos blockPos, RandomSource random) {
        boolean isWater = level.getFluidState(blockPos.below()).is(FluidTags.WATER) && level.getBlockState(blockPos.above()).is(Blocks.WATER);
        boolean isRaided = level.canSeeSkyFromBelowWater(blockPos) && level.getLevel().isRaided(blockPos);
        return isWater && (isRaided || TerrainUtils.isInFeature(level.getLevel(), blockPos, FOTTags.Structures.BATTLEGILLS_SPAWN_IN));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.TEMPT_RANGE, 10.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.01);
    }
}

