/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;

public abstract class CompositeSpawnCondition
implements SpawnCondition {
    protected final List<SpawnCondition> terms;
    private final Predicate<SpawnContext> composedPredicate;

    protected CompositeSpawnCondition(List<SpawnCondition> terms, Predicate<SpawnContext> composedPredicate) {
        this.terms = terms;
        this.composedPredicate = composedPredicate;
    }

    protected static <T extends CompositeSpawnCondition> MapCodec<T> createCodec(Function<List<SpawnCondition>, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)SpawnCondition.CODEC.listOf().fieldOf("terms").forGetter(compositeSpawnCondition -> compositeSpawnCondition.terms)).apply((Applicative)instance, factory));
    }

    public final boolean test(SpawnContext context) {
        return this.composedPredicate.test(context);
    }

    public static abstract class Builder {
        private final ImmutableList.Builder<SpawnCondition> terms = ImmutableList.builder();

        protected Builder(SpawnCondition ... conditions) {
            for (SpawnCondition builder : conditions) {
                this.terms.add((Object)builder);
            }
        }

        public void addTerm(SpawnCondition condition) {
            this.terms.add((Object)condition);
        }

        public SpawnCondition build() {
            return this.create((List<SpawnCondition>)this.terms.build());
        }

        protected abstract SpawnCondition create(List<SpawnCondition> var1);
    }
}

