/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;

public record ProbabilityCheck(float chance) implements SpawnCondition
{
    public static final MapCodec<ProbabilityCheck> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(ProbabilityCheck::chance)).apply((Applicative)instance, ProbabilityCheck::new));

    public MapCodec<? extends SpawnCondition> codec() {
        return CODEC;
    }

    public boolean test(SpawnContext context) {
        return context.level().getRandom().nextFloat() < this.chance;
    }

    public static SpawnCondition chance(float chance) {
        return new ProbabilityCheck(chance);
    }

    public static SpawnCondition defaultRareProbablity() {
        return new ProbabilityCheck(0.05f);
    }
}

