/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.BananaClusterGrowableStemBlock;
import com.stevekung.fishofthieves.registry.FOTTreeDecoratorTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.util.TriConsumer;

public class BananaDecorator
extends TreeDecorator {
    public static final MapCodec<BananaDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ripe_probability").forGetter(decorator -> Float.valueOf(decorator.ripeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("barely_ripe_probability").forGetter(decorator -> Float.valueOf(decorator.barelyRipeProbability)), (App)Codec.intRange((int)1, (int)16).fieldOf("max_banana_cluster").forGetter(decorator -> decorator.maxBananaCluster)).apply((Applicative)instance, BananaDecorator::new));
    private final float probability;
    private final float ripeProbability;
    private final float barelyRipeProbability;
    private final int maxBananaCluster;

    public BananaDecorator(float probability, float ripeProbability, float barelyRipeProbability, int maxBananaCluster) {
        this.probability = probability;
        this.ripeProbability = ripeProbability;
        this.barelyRipeProbability = barelyRipeProbability;
        this.maxBananaCluster = maxBananaCluster;
    }

    protected TreeDecoratorType<?> type() {
        return FOTTreeDecoratorTypes.BANANA;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        ObjectArrayList list = context.logs();
        int yAtStart = ((BlockPos)list.getFirst()).getY();
        Integer maxY = Collections.max(list.stream().map(blockPos -> blockPos.getY() - yAtStart).toList());
        int yToGrowAt = maxY - 1;
        list.stream().filter(blockPos -> blockPos.getY() - yAtStart == yToGrowAt).forEach(blockPos -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Direction direction2;
                BlockPos blockPos2;
                if (randomSource.nextFloat() >= this.probability || !context.isAir(blockPos2 = blockPos.offset((direction2 = direction.getOpposite()).getStepX(), 0, direction2.getStepZ()))) continue;
                BananaClusterGrowableStemBlock.growBananaBlossomOrCluster(direction2, context.level(), (TriConsumer<BlockPos, BlockState, Integer>)((TriConsumer)(blockPos1, blockState, flags) -> context.setBlock(blockPos1, blockState)), blockPosx -> context.level().isFluidAtPosition(blockPosx, fluidState -> fluidState.is((Fluid)Fluids.WATER)), randomSource, blockPos2);
            }
        });
    }
}

