/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.neoforge.proxy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.compatibility.terrablender.FOTTerraBlender;
import com.stevekung.fishofthieves.loot.FOTLootManager;
import com.stevekung.fishofthieves.registry.FOTTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

public class CommonProxyNeoForge {
    public void init() {
        NeoForge.EVENT_BUS.register((Object)this);
        IEventBus eventBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::registerAttributes);
        eventBus.addListener(this::registerSpawnPlacement);
        eventBus.addListener(this::onAddPackFinders);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            if (FOTPlatform.isModLoaded("terrablender")) {
                FOTTerraBlender.init();
            }
        });
    }

    @SubscribeEvent
    public void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.is(FOTTags.Items.WOODEN_FISH_PLAQUE)) {
            event.setBurnTime(300);
        }
    }

    @SubscribeEvent
    public void registerVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.FISHERMAN) {
            Int2ObjectMap trades = event.getTrades();
            FishOfThieves.getFishermanTrades().forEach((level, factories) -> ((List)trades.get(level.intValue())).addAll((Collection)factories.apply(Lists.newArrayList())));
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        HolderLookup.Provider provider = event.getRegistries();
        LootTable table = event.getTable();
        ResourceKey id = event.getKey();
        FOTLootManager.getInjectedLootTableMap().forEach((resourceKey, function) -> {
            if (id.equals(resourceKey)) {
                CommonProxyNeoForge.injectLoot(table, (ImmutableList.Builder<LootPoolEntryContainer>)((LootPool.Builder)function.apply(LootPool.lootPool(), provider)).entries);
            }
        });
        FOTLootManager.getInjectedLootPoolMap().forEach((resourceKey, function) -> {
            if (id.equals(resourceKey)) {
                table.addPool(((LootPool.Builder)function.apply(LootPool.lootPool(), provider)).build());
            }
        });
    }

    private void registerSpawnPlacement(RegisterSpawnPlacementsEvent event) {
        FishOfThieves.getSpawnPlacements().forEach(entry -> event.register(entry.type(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, entry.spawnPredicate(), RegisterSpawnPlacementsEvent.Operation.OR));
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        FishOfThieves.getEntityAttributes().forEach((entityType, builder) -> event.put(entityType, builder.build()));
    }

    private void onAddPackFinders(AddPackFindersEvent event) {
        event.addPackFinders(FishOfThieves.id("simple_spawning_condition_pack"), PackType.SERVER_DATA, (Component)Component.translatable((String)"dataPack.simple_spawning_condition_pack.name"), PackSource.FEATURE, false, Pack.Position.TOP);
    }

    private static void injectLoot(LootTable table, ImmutableList.Builder<LootPoolEntryContainer> builder) {
        LootPool pool = table.getPool("main");
        pool.entries = Lists.newArrayList((Iterable)pool.entries);
        pool.entries.addAll(builder.build());
    }
}

