/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.animal.Ancientscale;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.entity.animal.Devilfish;
import com.stevekung.fishofthieves.entity.animal.Islehopper;
import com.stevekung.fishofthieves.entity.animal.Plentifin;
import com.stevekung.fishofthieves.entity.animal.Pondie;
import com.stevekung.fishofthieves.entity.animal.Splashtail;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import com.stevekung.fishofthieves.entity.animal.Wildsplash;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.registry.FOTItems;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class FOTEntities {
    public static final EntityType<Splashtail> SPLASHTAIL = FOTEntities.register("splashtail", key -> FOTEntities.createFishEntityType(key, Splashtail::new, EntityDimensions.fixed((float)0.7f, (float)0.4f)));
    public static final EntityType<Pondie> PONDIE = FOTEntities.register("pondie", key -> FOTEntities.createFishEntityType(key, Pondie::new, EntityDimensions.fixed((float)0.6f, (float)0.5f)));
    public static final EntityType<Islehopper> ISLEHOPPER = FOTEntities.register("islehopper", key -> FOTEntities.createFishEntityType(key, Islehopper::new, EntityDimensions.fixed((float)0.55f, (float)0.45f)));
    public static final EntityType<Ancientscale> ANCIENTSCALE = FOTEntities.register("ancientscale", key -> FOTEntities.createFishEntityType(key, Ancientscale::new, EntityDimensions.fixed((float)0.6f, (float)0.5f)));
    public static final EntityType<Plentifin> PLENTIFIN = FOTEntities.register("plentifin", key -> FOTEntities.createFishEntityType(key, Plentifin::new, EntityDimensions.fixed((float)0.5f, (float)0.45f)));
    public static final EntityType<Wildsplash> WILDSPLASH = FOTEntities.register("wildsplash", key -> FOTEntities.createFishEntityType(key, Wildsplash::new, EntityDimensions.fixed((float)0.6f, (float)0.5f)));
    public static final EntityType<Devilfish> DEVILFISH = FOTEntities.register("devilfish", key -> FOTEntities.createFishEntityType(key, Devilfish::new, EntityDimensions.fixed((float)0.5f, (float)0.55f)));
    public static final EntityType<Battlegill> BATTLEGILL = FOTEntities.register("battlegill", key -> FOTEntities.createFishEntityType(key, Battlegill::new, EntityDimensions.fixed((float)0.5f, (float)0.55f)));
    public static final EntityType<Wrecker> WRECKER = FOTEntities.register("wrecker", key -> FOTEntities.createFishEntityType(key, Wrecker::new, EntityDimensions.fixed((float)0.5f, (float)0.5f)));
    public static final EntityType<Stormfish> STORMFISH = FOTEntities.register("stormfish", key -> FOTEntities.createFishEntityType(key, Stormfish::new, EntityDimensions.fixed((float)0.75f, (float)0.55f)));
    public static final EntityType<Boat> COCONUT_BOAT = FOTEntities.register("coconut_boat", key -> FOTEntities.createBoatEntityType(key, FOTEntities.boatFactory(() -> FOTItems.COCONUT_BOAT)));
    public static final EntityType<ChestBoat> COCONUT_CHEST_BOAT = FOTEntities.register("coconut_chest_boat", key -> FOTEntities.createBoatEntityType(key, FOTEntities.chestBoatFactory(() -> FOTItems.COCONUT_CHEST_BOAT)));

    public static void init() {
        FishOfThieves.LOGGER.info("Registering Entity");
    }

    private static <T extends Entity> EntityType<T> register(String key, Function<String, EntityType<T>> type) {
        return (EntityType)Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)FishOfThieves.id(key), type.apply(key));
    }

    private static EntityType.EntityFactory<Boat> boatFactory(Supplier<Item> boatItemGetter) {
        return (entityType, level) -> new Boat(entityType, level, boatItemGetter);
    }

    private static EntityType.EntityFactory<ChestBoat> chestBoatFactory(Supplier<Item> boatItemGetter) {
        return (entityType, level) -> new ChestBoat(entityType, level, boatItemGetter);
    }

    private static <T extends Entity> EntityType<T> createFishEntityType(String key, EntityType.EntityFactory<T> entityFactory, EntityDimensions dimensions) {
        return EntityType.Builder.of(entityFactory, (MobCategory)MobCategory.WATER_AMBIENT).sized(dimensions.width(), dimensions.height()).clientTrackingRange(4).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)FishOfThieves.id(key)));
    }

    private static <T extends Entity> EntityType<T> createBoatEntityType(String key, EntityType.EntityFactory<T> entityFactory) {
        return EntityType.Builder.of(entityFactory, (MobCategory)MobCategory.MISC).noLootTable().sized(1.375f, 0.5625f).eyeHeight(0.5625f).clientTrackingRange(10).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)FishOfThieves.id(key)));
    }

    public static interface SpawnData {
        public static final WeightedList<MobSpawnSettings.SpawnerData> ANCIENTSCALE = WeightedList.builder().add((Object)new MobSpawnSettings.SpawnerData(ANCIENTSCALE, 4, 8), 12).build();
        public static final WeightedList<MobSpawnSettings.SpawnerData> PLENTIFIN = WeightedList.builder().add((Object)new MobSpawnSettings.SpawnerData(PLENTIFIN, 4, 8), 12).build();
        public static final WeightedList<MobSpawnSettings.SpawnerData> ANCIENTSCALE_AND_PLENTIFIN = WeightedList.of((Weighted[])new Weighted[]{(Weighted)ANCIENTSCALE.unwrap().getFirst(), (Weighted)PLENTIFIN.unwrap().getFirst()});
        public static final WeightedList<MobSpawnSettings.SpawnerData> BATTLEGILL = WeightedList.builder().add((Object)new MobSpawnSettings.SpawnerData(BATTLEGILL, 2, 4), 5).build();
        public static final WeightedList<MobSpawnSettings.SpawnerData> WRECKER = WeightedList.builder().add((Object)new MobSpawnSettings.SpawnerData(WRECKER, 4, 8), 50).build();
    }
}

