/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllConditionCheck;
import com.stevekung.fishofthieves.entity.condition.NightCheck;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCheck;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCheck;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.BattlegillVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.level.biome.Biomes;

public class BattlegillVariants {
    public static final ResourceKey<BattlegillVariant> JADE = BattlegillVariants.createKey("jade");
    public static final ResourceKey<BattlegillVariant> SKY = BattlegillVariants.createKey("sky");
    public static final ResourceKey<BattlegillVariant> RUM = BattlegillVariants.createKey("rum");
    public static final ResourceKey<BattlegillVariant> SAND = BattlegillVariants.createKey("sand");
    public static final ResourceKey<BattlegillVariant> BITTERSWEET = BattlegillVariants.createKey("bittersweet");

    public static void bootstrap(BootstrapContext<BattlegillVariant> context) {
        AbstractFishVariant.RegisterContext<BattlegillVariant> registerContext = AbstractFishVariant.RegisterContext.create("battlegill", BattlegillVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, JADE, "jade", 0);
        registerContext.register(context, SKY, "sky", 1, SeeSkyCheck.seeSky());
        registerContext.register(context, RUM, "rum", 2);
        registerContext.register(context, SAND, "sand", 3, AllConditionCheck.allOf(new SpawnCondition[]{ProbabilityCheck.defaultRareProbablity(), new BiomeCheck((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.DESERT), biomeLookup.getOrThrow(Biomes.WARM_OCEAN), biomeLookup.getOrThrow(Biomes.LUKEWARM_OCEAN), biomeLookup.getOrThrow(Biomes.DEEP_LUKEWARM_OCEAN)}))}));
        registerContext.register(context, BITTERSWEET, "bittersweet", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    public static void bootstrapSimple(BootstrapContext<BattlegillVariant> context) {
        AbstractFishVariant.RegisterContext<BattlegillVariant> registerContext = AbstractFishVariant.RegisterContext.create("battlegill", BattlegillVariant::new);
        registerContext.register(context, JADE, "jade", 0);
        registerContext.register(context, SKY, "sky", 1);
        registerContext.register(context, RUM, "rum", 2);
        registerContext.register(context, SAND, "sand", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, BITTERSWEET, "bittersweet", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    private static ResourceKey<BattlegillVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.BATTLEGILL_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

