/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllConditionCheck;
import com.stevekung.fishofthieves.entity.condition.AnyConditionCheck;
import com.stevekung.fishofthieves.entity.condition.InvertedCondition;
import com.stevekung.fishofthieves.entity.condition.NightCheck;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCheck;
import com.stevekung.fishofthieves.entity.condition.RainingCheck;
import com.stevekung.fishofthieves.entity.condition.RandomChanceCheck;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCheck;
import com.stevekung.fishofthieves.entity.condition.TimeOfDayCheck;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.PlentifinVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.StructureCheck;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;

public class PlentifinVariants {
    public static final ResourceKey<PlentifinVariant> OLIVE = PlentifinVariants.createKey("olive");
    public static final ResourceKey<PlentifinVariant> AMBER = PlentifinVariants.createKey("amber");
    public static final ResourceKey<PlentifinVariant> CLOUDY = PlentifinVariants.createKey("cloudy");
    public static final ResourceKey<PlentifinVariant> BONEDUST = PlentifinVariants.createKey("bonedust");
    public static final ResourceKey<PlentifinVariant> WATERY = PlentifinVariants.createKey("watery");

    public static void bootstrap(BootstrapContext<PlentifinVariant> context) {
        AbstractFishVariant.RegisterContext<PlentifinVariant> registerContext = AbstractFishVariant.RegisterContext.create("plentifin", PlentifinVariant::new);
        HolderGetter structureLookup = context.lookup(Registries.STRUCTURE);
        registerContext.register(context, OLIVE, "olive", 0);
        registerContext.register(context, AMBER, "amber", 1, AllConditionCheck.allOf(InvertedCondition.invert(RainingCheck.raining().build()), TimeOfDayCheck.timeOfDay(MinMaxBounds.Doubles.between((double)0.75, (double)0.9)), SeeSkyCheck.seeSky()));
        registerContext.register(context, CLOUDY, "cloudy", 2, AllConditionCheck.allOf(RainingCheck.raining().build(), SeeSkyCheck.seeSky()));
        registerContext.register(context, BONEDUST, "bonedust", 3, registerContext.select(AllConditionCheck.allOf(AnyConditionCheck.anyOf(new SpawnCondition[]{new StructureCheck((HolderSet)HolderSet.direct((Holder[])new Holder[]{structureLookup.getOrThrow(BuiltinStructures.STRONGHOLD)})), new StructureCheck((HolderSet)structureLookup.getOrThrow(StructureTags.MINESHAFT))}).build(), RandomChanceCheck.chance(10)), 1), registerContext.select(ProbabilityCheck.defaultRareProbablity(), 0));
        registerContext.register(context, WATERY, "watery", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    public static void bootstrapSimple(BootstrapContext<PlentifinVariant> context) {
        AbstractFishVariant.RegisterContext<PlentifinVariant> registerContext = AbstractFishVariant.RegisterContext.create("plentifin", PlentifinVariant::new);
        registerContext.register(context, OLIVE, "olive", 0);
        registerContext.register(context, AMBER, "amber", 1);
        registerContext.register(context, CLOUDY, "cloudy", 2);
        registerContext.register(context, BONEDUST, "bonedust", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, WATERY, "watery", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    private static ResourceKey<PlentifinVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.PLENTIFIN_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

