/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.structure;

import com.google.common.collect.ImmutableMap;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTLootTables;
import com.stevekung.fishofthieves.registry.FOTStructures;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.LootTable;

public class SeapostPieces {
    private static final ResourceLocation SEAPOST = FishOfThieves.id("seapost");
    private static final ResourceLocation SEAPOST_BASE = FishOfThieves.id("seapost_base");
    private static final Map<ResourceLocation, BlockPos> PIVOTS = ImmutableMap.of((Object)SEAPOST, (Object)new BlockPos(-5, 0, 10), (Object)SEAPOST_BASE, (Object)new BlockPos(-5, 0, 11));
    private static final Map<ResourceLocation, BlockPos> OFFSETS = ImmutableMap.of((Object)SEAPOST, (Object)new BlockPos(0, 8, 0), (Object)SEAPOST_BASE, (Object)BlockPos.ZERO);
    private static final List<Block> POTTED_BLOCKS = List.of(Blocks.POTTED_POPPY, Blocks.POTTED_DANDELION, Blocks.POTTED_AZURE_BLUET, Blocks.POTTED_DEAD_BUSH, Blocks.POTTED_MANGROVE_PROPAGULE, Blocks.POTTED_AZALEA, Blocks.POTTED_FLOWERING_AZALEA, FOTBlocks.POTTED_PINK_PLUMERIA, FOTBlocks.POTTED_WHITE_PLUMERIA, FOTBlocks.POTTED_LIGHT_BLUE_PLUMERIA);

    public static void addPieces(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor pieces) {
        pieces.addPiece((StructurePiece)new SeapostPiece(structureTemplateManager, SEAPOST, pos, rotation, 8));
        pieces.addPiece((StructurePiece)new SeapostPiece(structureTemplateManager, SEAPOST_BASE, pos.below(1), rotation, 0));
    }

    public static class SeapostPiece
    extends TemplateStructurePiece {
        public SeapostPiece(StructureTemplateManager structureTemplateManager, ResourceLocation resourceLocation, BlockPos blockPos, Rotation rotation, int offset) {
            super(FOTStructures.PieceType.SEAPOST_PIECE, 0, structureTemplateManager, resourceLocation, resourceLocation.toString(), SeapostPiece.makeSettings(rotation, resourceLocation), SeapostPiece.makePosition(resourceLocation, blockPos, offset));
        }

        public SeapostPiece(StructureTemplateManager structureTemplateManager, CompoundTag compoundTag) {
            super(FOTStructures.PieceType.SEAPOST_PIECE, compoundTag, structureTemplateManager, resourceLocation -> SeapostPiece.makeSettings((Rotation)compoundTag.read("Rot", Rotation.LEGACY_CODEC).orElseThrow(), resourceLocation));
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putString("Rot", this.placeSettings.getRotation().name());
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, ResourceLocation location) {
            return new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).setRotationPivot(PIVOTS.get(location)).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        }

        private static BlockPos makePosition(ResourceLocation location, BlockPos pos, int down) {
            return pos.offset((Vec3i)OFFSETS.get(location)).below(down);
        }

        private ResourceKey<LootTable> getRandomLootTables(RandomSource random) {
            if (random.nextFloat() < 0.35f) {
                return FOTLootTables.Chests.SEAPOST_BARREL_COMBAT;
            }
            if (random.nextFloat() < 0.2f) {
                return FOTLootTables.Chests.SEAPOST_BARREL_FIREWORK;
            }
            return FOTLootTables.Chests.SEAPOST_BARREL_SUPPLY;
        }

        protected void handleDataMarker(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
            HolderLookup villagerTypeLookup = level.holderLookup(Registries.VILLAGER_TYPE);
            HolderLookup villagerProfessionLookup = level.holderLookup(Registries.VILLAGER_PROFESSION);
            switch (name) {
                case "seapost_barrel": {
                    BlockEntity blockEntity = level.getBlockEntity(pos.below());
                    if (!(blockEntity instanceof RandomizableContainer)) break;
                    RandomizableContainer randomizableContainer = (RandomizableContainer)blockEntity;
                    randomizableContainer.setLootTable(this.getRandomLootTables(random), random.nextLong());
                    break;
                }
                case "seapost_barrel_with_flower_pot": {
                    BlockEntity blockEntity = level.getBlockEntity(pos.below());
                    if (blockEntity instanceof RandomizableContainer) {
                        RandomizableContainer randomizableContainer = (RandomizableContainer)blockEntity;
                        randomizableContainer.setLootTable(this.getRandomLootTables(random), random.nextLong());
                    }
                    level.setBlock(pos, ((Block)Util.getRandom(POTTED_BLOCKS, (RandomSource)random)).defaultBlockState(), 2);
                    break;
                }
                case "seapost_leather_worker": {
                    Villager villager = (Villager)EntityType.VILLAGER.create((Level)level.getLevel(), EntitySpawnReason.STRUCTURE);
                    villager.setVillagerData(new VillagerData((Holder)villagerTypeLookup.getOrThrow(VillagerType.PLAINS), (Holder)villagerProfessionLookup.getOrThrow(VillagerProfession.LEATHERWORKER), 1));
                    villager.setPersistenceRequired();
                    villager.snapTo(pos, 0.0f, 0.0f);
                    villager.finalizeSpawn(level, level.getCurrentDifficultyAt(villager.blockPosition()), EntitySpawnReason.STRUCTURE, null);
                    level.addFreshEntityWithPassengers((Entity)villager);
                    level.setBlock(pos, (BlockState)((BlockState)((BlockState)Blocks.SPRUCE_TRAPDOOR.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)this.placeSettings.getRotation().rotate(Direction.NORTH))).setValue((Property)TrapDoorBlock.HALF, (Comparable)Half.TOP)).setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(true)), 2);
                    break;
                }
                case "seapost_fisherman": {
                    Villager villager = (Villager)EntityType.VILLAGER.create((Level)level.getLevel(), EntitySpawnReason.STRUCTURE);
                    villager.setVillagerData(new VillagerData((Holder)villagerTypeLookup.getOrThrow(VillagerType.PLAINS), (Holder)villagerProfessionLookup.getOrThrow(VillagerProfession.FISHERMAN), 1));
                    villager.setPersistenceRequired();
                    villager.snapTo(pos, 0.0f, 0.0f);
                    villager.finalizeSpawn(level, level.getCurrentDifficultyAt(villager.blockPosition()), EntitySpawnReason.STRUCTURE, null);
                    level.addFreshEntityWithPassengers((Entity)villager);
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
                }
            }
        }

        public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)this.templateName);
            this.templatePosition = new BlockPos(this.templatePosition.getX(), generator.getSeaLevel() - OFFSETS.get(resourceLocation).getY(), this.templatePosition.getZ());
            super.postProcess(level, structureManager, generator, random, box, chunkPos, pos);
        }
    }
}

