/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.AbstractMangoFruitBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MangoFruitBlock
extends AbstractMangoFruitBlock {
    private static final VoxelShape[] EAST_AABB = new VoxelShape[]{Block.box((double)13.0, (double)5.0, (double)6.5, (double)16.0, (double)10.0, (double)9.5), Block.box((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)10.0, (double)10.5)};
    private static final VoxelShape[] WEST_AABB = new VoxelShape[]{Block.box((double)0.0, (double)5.0, (double)6.5, (double)3.0, (double)10.0, (double)9.5), Block.box((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)10.0, (double)10.5)};
    private static final VoxelShape[] NORTH_AABB = new VoxelShape[]{Block.box((double)6.5, (double)5.0, (double)0.0, (double)9.5, (double)10.0, (double)3.0), Block.box((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)10.0, (double)5.0)};
    private static final VoxelShape[] SOUTH_AABB = new VoxelShape[]{Block.box((double)6.5, (double)5.0, (double)13.0, (double)9.5, (double)10.0, (double)16.0), Block.box((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)10.0, (double)16.0)};
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;

    public MangoFruitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)FALLING, (Comparable)Boolean.valueOf(false)));
    }

    public float getMaxHorizontalOffset() {
        return 0.0f;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.relative((Direction)state.getValue(FACING)));
        return blockState.is(FOTBlocks.MANGO_LEAVES);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int age = Math.min((Integer)state.getValue((Property)AGE), 1);
        Vec3 offset = state.getOffset(pos);
        return (switch ((Direction)state.getValue(FACING)) {
            case Direction.SOUTH -> SOUTH_AABB[age];
            case Direction.WEST -> WEST_AABB[age];
            case Direction.EAST -> EAST_AABB[age];
            default -> NORTH_AABB[age];
        }).move(offset.x, offset.y, offset.z);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FACING}));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }
}

