/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.renderer.entity.state.ThievesFishRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class DevilfishModel<S extends ThievesFishRenderState>
extends EntityModel<S>
implements HeadphoneModel.Scaleable<S> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("devilfish"), "main");
    private final ModelPart mouth;
    private final ModelPart body_back;

    public DevilfishModel(ModelPart part) {
        super(part, RenderType::entityCutout);
        ModelPart main = part.getChild("main");
        this.mouth = main.getChild("head").getChild("mouth");
        this.body_back = main.getChild("body_back");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition main = partDefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = main.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.5f, (float)-3.5f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(18, 7).addBox(-2.0f, -2.25f, -0.175f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)1.4f, (float)-1.475f, (float)0.7854f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(18, 0).addBox(-2.0f, -2.63f, -0.35f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)0.63f, (float)-0.15f, (float)0.5149f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.0f, (float)0.25f));
        mouth.addOrReplaceChild("mouth_r1", CubeListBuilder.create().texOffs(12, 17).addBox(-2.0f, -1.0f, -4.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        mouth.addOrReplaceChild("mouth_r2", CubeListBuilder.create().texOffs(0, 11).addBox(-2.0f, 0.0f, -5.25f, 4.0f, 1.0f, 5.0f, new CubeDeformation(0.05f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition body_main = main.addOrReplaceChild("body_main", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.25f, -2.25f, 4.0f, 6.0f, 5.0f, CubeDeformation.NONE).texOffs(6, 22).addBox(0.0f, -5.25f, -2.25f, 0.0f, 2.0f, 5.0f, CubeDeformation.NONE).texOffs(6, 25).addBox(0.0f, 2.75f, -1.75f, 0.0f, 2.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-4.75f, (float)-1.25f));
        body_main.addOrReplaceChild("right_fin_r1", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-3.0f, -9.5f, 0.0f, 3.0f, 3.0f, 0.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)8.75f, (float)0.25f, (float)0.0f, (float)0.7854f, (float)0.0f));
        body_main.addOrReplaceChild("left_fin_r1", CubeListBuilder.create().texOffs(6, 24).addBox(0.0f, -9.5f, 0.0f, 3.0f, 3.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0f, (float)8.75f, (float)0.25f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition body_back = main.addOrReplaceChild("body_back", CubeListBuilder.create().texOffs(0, 17).addBox(-1.5f, -2.0f, -0.5f, 3.0f, 4.0f, 3.0f, CubeDeformation.NONE).texOffs(16, 22).addBox(0.0f, -4.0f, 0.0f, 0.0f, 2.0f, 2.0f, CubeDeformation.NONE).texOffs(0, 24).addBox(0.0f, -2.5f, 2.5f, 0.0f, 5.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-5.0f, (float)1.5f));
        body_back.addOrReplaceChild("right_fin_r2", CubeListBuilder.create().texOffs(16, 25).addBox(0.0f, 0.0f, 1.75f, 0.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.5f, (float)2.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.5236f));
        body_back.addOrReplaceChild("left_fin_r2", CubeListBuilder.create().texOffs(16, 27).addBox(0.0f, 0.0f, 1.75f, 0.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.5f, (float)2.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void setupAnim(S renderState) {
        float backRotation = 1.0f;
        float backRotSpeed = 1.0f;
        float mouthSpeed = 0.4f;
        if (!((ThievesFishRenderState)((Object)renderState)).isInWater && !((ThievesFishRenderState)((Object)renderState)).isNoFlip) {
            backRotation = 1.5f;
            backRotSpeed = 1.7f;
            mouthSpeed = 1.8f;
        }
        this.body_back.yRot = -backRotation * 0.2f * Mth.sin((float)(backRotSpeed * 0.6f * ((ThievesFishRenderState)((Object)renderState)).ageInTicks));
        this.mouth.xRot = -0.0f + Mth.cos((float)(mouthSpeed * ((ThievesFishRenderState)((Object)renderState)).ageInTicks)) * (float)Math.PI * 0.06f;
    }

    @Override
    public void scale(S renderState, PoseStack poseStack) {
        float scale = 1.5f;
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0f, -0.35f, -0.075f);
    }
}

