/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.renderer.entity.layers.GlowFishLayer;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.client.renderer.entity.state.ThievesFishRenderState;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.VariantHolder;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import java.util.function.Consumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.AbstractFish;
import org.joml.Quaternionfc;

public abstract class ThievesFishRenderer<V extends AbstractFishVariant, S extends ThievesFishRenderState, T extends AbstractFish & VariantHolder<Holder<V>>, M extends EntityModel<S>>
extends MobRenderer<T, S, M> {
    protected ThievesFishRenderer(EntityRendererProvider.Context context, M entityModel) {
        super(context, entityModel, 0.15f);
        this.addLayer(new GlowFishLayer(this));
        this.addLayer(new HeadphoneLayer((LivingEntityRenderer<?, ?, ?>)this, context.getModelSet(), (HeadphoneModel.Scaleable)entityModel));
    }

    public void submit(S renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        this.shadowRadius = ((ThievesFishRenderState)((Object)renderState)).isTrophy ? 0.25f : 0.15f;
        super.submit(renderState, poseStack, submitNodeCollector, cameraRenderState);
    }

    public S createRenderState() {
        return (S)((Object)new ThievesFishRenderState());
    }

    public void extractRenderState(T entity, S renderState, float partialTicks) {
        super.extractRenderState(entity, renderState, partialTicks);
        AbstractFishVariant variant = (AbstractFishVariant)((Holder)((VariantHolder)entity).getVariant()).value();
        ((ThievesFishRenderState)((Object)renderState)).isTrophy = ((ThievesFish)entity).isTrophy();
        ((ThievesFishRenderState)((Object)renderState)).isNoFlip = ((ThievesFish)entity).isNoFlip();
        ((ThievesFishRenderState)((Object)renderState)).hasImpulse = ((AbstractFish)entity).hasImpulse;
        ((ThievesFishRenderState)((Object)renderState)).fullTexture = variant.fullTexture();
        ((ThievesFishRenderState)((Object)renderState)).fullGlowTexture = variant.fullGlowTexture().orElse(null);
        ((ThievesFishRenderState)((Object)renderState)).glowBrightness = ((ThievesFish)entity).getGlowBrightness(((ThievesFishRenderState)((Object)renderState)).ageInTicks);
    }

    protected void setupRotations(S renderState, PoseStack poseStack, float bodyRot, float scale) {
        super.setupRotations(renderState, poseStack, bodyRot, scale);
        boolean inWater = ((ThievesFishRenderState)((Object)renderState)).isInWater || ((ThievesFishRenderState)((Object)renderState)).isNoFlip;
        RotationRenderData rotationRenderData = this.setupRotations(renderState, inWater);
        float degree = rotationRenderData.baseDegree * Mth.sin((float)(rotationRenderData.bodyRotBase * rotationRenderData.bodyRotSpeed * ((ThievesFishRenderState)((Object)renderState)).ageInTicks));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(degree));
        if (!inWater) {
            rotationRenderData.translateConsumer.accept(poseStack);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
        }
        this.doFishPitchYaw(renderState, poseStack);
    }

    public ResourceLocation getTextureLocation(S renderState) {
        return ((ThievesFishRenderState)((Object)renderState)).fullTexture;
    }

    protected void scale(S livingEntity, PoseStack poseStack) {
        float scale = ((ThievesFishRenderState)((Object)livingEntity)).isTrophy ? 1.0f : 0.5f;
        poseStack.scale(scale, scale, scale);
    }

    private void doFishPitchYaw(S renderState, PoseStack poseStack) {
        if (!((ThievesFishRenderState)((Object)renderState)).hasImpulse) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotation(((ThievesFishRenderState)((Object)renderState)).xRot * ((float)(-Math.PI) / 180)));
        }
    }

    public abstract RotationRenderData setupRotations(S var1, boolean var2);

    public record RotationRenderData(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<PoseStack> translateConsumer) {
        public static RotationRenderData create(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<PoseStack> translateConsumer) {
            return new RotationRenderData(bodyRotBase, bodyRotSpeed, baseDegree, translateConsumer);
        }
    }
}

