/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stevekung.fishofthieves.block.FishPlaqueBlock;
import com.stevekung.fishofthieves.blockentity.FishPlaqueBlockEntity;
import com.stevekung.fishofthieves.client.renderer.blockentity.state.FishPlaqueBlockEntityRenderState;
import com.stevekung.fishofthieves.registry.FOTTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class FishPlaqueRenderer
implements BlockEntityRenderer<FishPlaqueBlockEntity, FishPlaqueBlockEntityRenderState> {
    private final EntityRenderDispatcher entityRenderer;

    public FishPlaqueRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.entityRenderer();
    }

    public void extractRenderState(FishPlaqueBlockEntity blockEntity, FishPlaqueBlockEntityRenderState fishPlaqueState, float partialTicks, Vec3 vec3, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Entity entity;
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)fishPlaqueState, partialTicks, vec3, crumblingOverlay);
        if (blockEntity.getLevel() != null && (entity = blockEntity.getOrCreateDisplayEntity(blockEntity.getLevel())) != null) {
            EntityType entityType = entity.getType();
            float maxScale = Math.max(entity.getBbWidth(), entity.getBbHeight());
            fishPlaqueState.scale = 0.53125f;
            if (maxScale > 1.0f) {
                fishPlaqueState.scale /= maxScale;
            }
            boolean powered = (Boolean)blockEntity.getBlockState().getValue((Property)FishPlaqueBlock.POWERED) != false && entityType.is(FOTTags.EntityTypes.FISH_PLAQUE_HORIZONTAL_RENDER_ON_POWERED);
            entity.fishofthieves$setIsInFishPlaque(powered);
            fishPlaqueState.isHorizontal = entity.isInWater() || entityType.is(FOTTags.EntityTypes.FISH_PLAQUE_HORIZONTAL_RENDER);
            fishPlaqueState.displayEntity = this.entityRenderer.extractEntity(entity, blockEntity.getAnimation(partialTicks));
            fishPlaqueState.displayEntity.lightCoords = fishPlaqueState.lightCoords;
            fishPlaqueState.displayEntity.hitboxesRenderState = null;
            EntityRenderState entityRenderState = fishPlaqueState.displayEntity;
            if (entityRenderState instanceof LivingEntityRenderState) {
                LivingEntityRenderState livingEntityRenderState = (LivingEntityRenderState)entityRenderState;
                livingEntityRenderState.bodyRot = 0.0f;
            }
        }
    }

    public void submit(FishPlaqueBlockEntityRenderState fishPlaqueState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        EntityRenderState entityRenderState = fishPlaqueState.displayEntity;
        if (entityRenderState != null) {
            BlockState blockState = fishPlaqueState.blockState;
            Direction facing = (Direction)blockState.getValue(FishPlaqueBlock.FACING);
            int rotation = (Integer)blockState.getValue((Property)FishPlaqueBlock.ROTATION) - 1;
            float scale = fishPlaqueState.scale;
            boolean isHorizontal = fishPlaqueState.isHorizontal;
            float stepMultiplier = isHorizontal ? 0.3f : 0.4f;
            float yDegree = -facing.toYRot() + 90.0f;
            Vec3 vec3Translate = new Vec3((double)((float)facing.getStepX() * stepMultiplier), (double)(-scale), (double)((float)facing.getStepZ() * stepMultiplier));
            poseStack.translate(-vec3Translate.x(), -vec3Translate.y(), -vec3Translate.z());
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(yDegree));
            poseStack.translate(0.0f, -0.02f, 0.0f);
            if (isHorizontal) {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees((float)rotation * 360.0f / 8.0f));
                poseStack.translate(0.0f, -0.1f, 0.0f);
            } else {
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(-rotation) * 360.0f / 8.0f));
            }
            poseStack.scale(scale, scale, scale);
            this.entityRenderer.submit(entityRenderState, cameraRenderState, 0.0, 0.0, 0.0, poseStack, (SubmitNodeCollector)Minecraft.getInstance().gameRenderer.getSubmitNodeStorage());
        }
        poseStack.popPose();
    }

    public FishPlaqueBlockEntityRenderState createRenderState() {
        return new FishPlaqueBlockEntityRenderState();
    }
}

