/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;

public class NonCreativePlayerSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_PLAYERS, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
    }

    protected void doTick(ServerLevel level, LivingEntity entity) {
        List list = level.players().stream().filter(EntitySelector.NO_CREATIVE_OR_SPECTATOR).filter(serverPlayer -> entity.closerThan((Entity)serverPlayer, 16.0)).sorted(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).distanceToSqr(arg_0))).collect(Collectors.toList());
        Brain brain = entity.getBrain();
        brain.setMemory(MemoryModuleType.NEAREST_PLAYERS, list);
        List<Player> list2 = list.stream().filter(player -> NonCreativePlayerSensor.isEntityTargetable((ServerLevel)level, (LivingEntity)entity, (LivingEntity)player)).toList();
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER, list2.isEmpty() ? null : list2.getFirst());
        Optional<Player> optional = list2.stream().filter(player -> NonCreativePlayerSensor.isEntityAttackable((ServerLevel)level, (LivingEntity)entity, (LivingEntity)player)).findFirst();
        brain.setMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, optional);
    }
}

