/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractSchoolingThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.PondieVariant;
import com.stevekung.fishofthieves.registry.FOTDataComponentTypes;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.variant.PondieVariants;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Pondie
extends AbstractSchoolingThievesFish<PondieVariant> {
    private static final EntityDataAccessor<Holder<PondieVariant>> VARIANT = SynchedEntityData.defineId(Pondie.class, FOTDataSerializers.PONDIE_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:charcoal", (Object)0);
        map.put((Object)"fishofthieves:orchid", (Object)1);
        map.put((Object)"fishofthieves:bronze", (Object)2);
        map.put((Object)"fishofthieves:bright", (Object)3);
        map.put((Object)"fishofthieves:moonsky", (Object)4);
    });

    public Pondie(EntityType<? extends Pondie> entityType, Level level) {
        super(entityType, level, FOTRegistries.PONDIE_VARIANT, PondieVariants.CHARCOAL, FOTDataComponentTypes.PONDIE_VARIANT);
    }

    protected Brain.Provider<AbstractFlockFish> brainProvider() {
        return Brain.provider((Collection)MEMORY_TYPES, Stream.of(SENSOR_TYPES, List.of(FOTSensorTypes.COMMON_THIEVES_FISH_TEMPTATIONS)).flatMap(Collection::stream).toList());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return AbstractSchoolingThievesFishAi.makeBrain((Brain<AbstractFlockFish>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Pondie> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(ServerLevel serverLevel) {
        AbstractSchoolingThievesFishAi.customServerAiStep(this, this.getBrain());
        super.customServerAiStep(serverLevel);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.registryAccess().lookupOrThrow(FOTRegistries.PONDIE_VARIANT).getOrThrow(PondieVariants.CHARCOAL));
    }

    @Override
    public Holder<PondieVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    @Override
    public void setVariant(Holder<PondieVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)FOTItems.PONDIE_BUCKET);
    }

    protected SoundEvent getDeathSound() {
        return FOTSoundEvents.PONDIE_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return FOTSoundEvents.PONDIE_HURT;
    }

    protected SoundEvent getFlopSound() {
        return FOTSoundEvents.PONDIE_FLOP;
    }

    public int getMaxSchoolSize() {
        return 5;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isTrophy() ? super.getDefaultDimensions(pose).withEyeHeight(0.35f) : EntityDimensions.fixed((float)0.35f, (float)0.25f).withEyeHeight(0.18f);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(WORMS);
    }
}

