/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractSchoolingThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.WildsplashVariant;
import com.stevekung.fishofthieves.registry.FOTDataComponentTypes;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.WildsplashVariants;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class Wildsplash
extends AbstractSchoolingThievesFish<WildsplashVariant> {
    private static final EntityDataAccessor<Holder<WildsplashVariant>> VARIANT = SynchedEntityData.defineId(Wildsplash.class, FOTDataSerializers.WILDSPLASH_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:russet", (Object)0);
        map.put((Object)"fishofthieves:sandy", (Object)1);
        map.put((Object)"fishofthieves:ocean", (Object)2);
        map.put((Object)"fishofthieves:muddy", (Object)3);
        map.put((Object)"fishofthieves:coral", (Object)4);
    });

    public Wildsplash(EntityType<? extends Wildsplash> entityType, Level level) {
        super(entityType, level, FOTRegistries.WILDSPLASH_VARIANT, WildsplashVariants.RUSSET, FOTDataComponentTypes.WILDSPLASH_VARIANT);
    }

    protected Brain.Provider<AbstractFlockFish> brainProvider() {
        return Brain.provider((Collection)MEMORY_TYPES, Stream.of(SENSOR_TYPES, List.of(FOTSensorTypes.EARTHWORMS_THIEVES_FISH_TEMPTATIONS)).flatMap(Collection::stream).toList());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return AbstractSchoolingThievesFishAi.makeBrain((Brain<AbstractFlockFish>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Wildsplash> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(ServerLevel serverLevel) {
        AbstractSchoolingThievesFishAi.customServerAiStep(this, this.getBrain());
        super.customServerAiStep(serverLevel);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.registryAccess().lookupOrThrow(FOTRegistries.WILDSPLASH_VARIANT).getOrThrow(WildsplashVariants.RUSSET));
    }

    @Override
    public Holder<WildsplashVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    @Override
    public void setVariant(Holder<WildsplashVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)FOTItems.WILDSPLASH_BUCKET);
    }

    protected SoundEvent getDeathSound() {
        return FOTSoundEvents.WILDSPLASH_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return FOTSoundEvents.WILDSPLASH_HURT;
    }

    protected SoundEvent getFlopSound() {
        return FOTSoundEvents.WILDSPLASH_FLOP;
    }

    public int getMaxSchoolSize() {
        return 4;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isTrophy() ? super.getDefaultDimensions(pose).withEyeHeight(0.38f) : EntityDimensions.fixed((float)0.3f, (float)0.25f).withEyeHeight(0.2f);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(EARTHWORMS_FOOD);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, EntitySpawnReason entitySpawnReason, BlockPos blockPos, RandomSource random) {
        boolean isSurfaceWater = WaterAnimal.checkSurfaceWaterAnimalSpawnRules(entityType, (LevelAccessor)level, (EntitySpawnReason)entitySpawnReason, (BlockPos)blockPos, (RandomSource)random);
        boolean isWater = level.getFluidState(blockPos.below()).is(FluidTags.WATER) && level.getBlockState(blockPos.above()).is(Blocks.WATER);
        Holder biome = level.getBiome(blockPos);
        return isWater && biome.is(FOTTags.Biomes.SPAWNS_WILDSPLASH) || isSurfaceWater;
    }
}

