/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.variant;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.variant.PriorityProvider;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.ServerLevelAccessor;

public interface AbstractFishVariant
extends PriorityProvider<SpawnContext, SpawnCondition> {
    public int customModelData();

    public String name();

    public ClientAsset.ResourceTexture texture();

    public ResourceLocation fullTexture();

    public Optional<ResourceLocation> fullGlowTexture();

    public Optional<ClientAsset.ResourceTexture> glowTexture();

    public SpawnSettings spawnSettings();

    default public List<PriorityProvider.Selector<SpawnContext, SpawnCondition>> selectors() {
        return this.spawnSettings().entity().selectors();
    }

    public static <T> Stream<T> select(Stream<T> stream, Function<T, AbstractFishVariant> function, SpawnContext object) {
        ArrayList list = Lists.newArrayList();
        stream.forEach(objectx -> {
            AbstractFishVariant priorityProvider = (AbstractFishVariant)function.apply(objectx);
            List listx = priorityProvider.spawnSettings().fishing().isPresent() ? priorityProvider.spawnSettings().fishing().get().selectors() : priorityProvider.selectors();
            for (PriorityProvider.Selector<SpawnContext, SpawnCondition> selector : listx) {
                list.add(new PriorityProvider.UnpackedEntry(objectx, selector.priority(), (PriorityProvider.SelectorCondition)DataFixUtils.orElseGet((Optional)selector.condition(), PriorityProvider.SelectorCondition::alwaysTrue)));
            }
        });
        list.sort(PriorityProvider.UnpackedEntry.HIGHEST_PRIORITY_FIRST);
        Iterator iterator = list.iterator();
        int i = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            PriorityProvider.UnpackedEntry unpackedEntry = (PriorityProvider.UnpackedEntry)iterator.next();
            if (unpackedEntry.priority() < i) {
                iterator.remove();
                continue;
            }
            if (unpackedEntry.condition().test((Object)object)) {
                i = unpackedEntry.priority();
                continue;
            }
            iterator.remove();
        }
        return list.stream().map(PriorityProvider.UnpackedEntry::entry);
    }

    public static <T> Optional<T> pick(Stream<T> stream, Function<T, AbstractFishVariant> function, RandomSource randomSource, SpawnContext object) {
        List<T> list = AbstractFishVariant.select(stream, function, object).toList();
        return Util.getRandomSafe(list, (RandomSource)randomSource);
    }

    public static <T extends AbstractFishVariant> Codec<T> simpleCodec(Function5<String, ClientAsset.ResourceTexture, Optional<ClientAsset.ResourceTexture>, SpawnSettings, Integer, T> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("name").forGetter(AbstractFishVariant::name), (App)ClientAsset.ResourceTexture.CODEC.fieldOf("texture").forGetter(AbstractFishVariant::texture), (App)ClientAsset.ResourceTexture.CODEC.optionalFieldOf("glow_texture").forGetter(AbstractFishVariant::glowTexture), (App)SpawnSettings.CODEC.optionalFieldOf("spawn_settings", (Object)new SpawnSettings(SpawnPrioritySelectors.fallback((int)0), Optional.empty())).forGetter(AbstractFishVariant::spawnSettings), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("custom_model_data").forGetter(AbstractFishVariant::customModelData)).apply((Applicative)instance, factory));
    }

    public static <T extends AbstractFishVariant> Codec<T> networkCodec(Function4<String, ClientAsset.ResourceTexture, Optional<ClientAsset.ResourceTexture>, Integer, T> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("name").forGetter(AbstractFishVariant::name), (App)ClientAsset.ResourceTexture.CODEC.fieldOf("texture").forGetter(AbstractFishVariant::texture), (App)ClientAsset.ResourceTexture.CODEC.optionalFieldOf("glow_texture").forGetter(AbstractFishVariant::glowTexture), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("custom_model_data").forGetter(AbstractFishVariant::customModelData)).apply((Applicative)instance, factory));
    }

    public static <T extends AbstractFishVariant> Holder<T> getSpawnVariant(ServerLevel serverLevel, RegistryAccess registryAccess, ResourceKey<? extends Registry<? extends T>> registryKey, ResourceKey<T> defaultKey, LivingEntity livingEntity, boolean fromBucket) {
        Registry registry = registryAccess.lookupOrThrow(registryKey);
        SpawnContext context = new SpawnContext(livingEntity.blockPosition(), (ServerLevelAccessor)serverLevel, serverLevel.getBiome(livingEntity.blockPosition()));
        if (fromBucket) {
            Optional muha = Util.getRandomSafe(registry.listElements().toList(), (RandomSource)livingEntity.getRandom());
            return (Holder)muha.orElseGet(() -> registry.getOrThrow(defaultKey));
        }
        return (Holder)PriorityProvider.pick((Stream)registryAccess.lookupOrThrow(registryKey).listElements(), Holder::value, (RandomSource)livingEntity.getRandom(), (Object)context).orElseGet(() -> registry.getOrThrow(defaultKey));
    }

    public record SpawnSettings(SpawnPrioritySelectors entity, Optional<SpawnPrioritySelectors> fishing) {
        public static final Codec<SpawnSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpawnPrioritySelectors.CODEC.optionalFieldOf("entity", (Object)SpawnPrioritySelectors.fallback((int)0)).forGetter(SpawnSettings::entity), (App)SpawnPrioritySelectors.CODEC.optionalFieldOf("fishing").forGetter(SpawnSettings::fishing)).apply((Applicative)instance, SpawnSettings::new));
        public static final SpawnSettings EMPTY = new SpawnSettings(SpawnPrioritySelectors.EMPTY, Optional.empty());
    }

    public record RegisterContext<T>(String entityName, Function5<String, ClientAsset.ResourceTexture, Optional<ClientAsset.ResourceTexture>, SpawnSettings, Integer, T> factory) {
        public static <T> RegisterContext<T> create(String entityName, Function5<String, ClientAsset.ResourceTexture, Optional<ClientAsset.ResourceTexture>, SpawnSettings, Integer, T> factory) {
            return new RegisterContext<T>(entityName, factory);
        }

        public <Context, Condition extends PriorityProvider.SelectorCondition<Context>> PriorityProvider.Selector<Context, Condition> select(Condition condition, int priority) {
            return new PriorityProvider.Selector(condition, priority);
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData) {
            this.register(context, key, name, customModelData, false, PriorityProvider.alwaysTrue((int)0), Optional.empty());
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData, boolean glow) {
            this.register(context, key, name, customModelData, glow, PriorityProvider.alwaysTrue((int)0), Optional.empty());
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData, SpawnCondition condition) {
            this.register(context, key, name, customModelData, false, List.of(this.select(condition, 0)), Optional.empty());
        }

        @SafeVarargs
        public final void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData, PriorityProvider.Selector<SpawnContext, SpawnCondition> ... conditions) {
            this.register(context, key, name, customModelData, false, List.of(conditions), Optional.empty());
        }

        @SafeVarargs
        public final void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData, boolean glow, PriorityProvider.Selector<SpawnContext, SpawnCondition> ... conditions) {
            this.register(context, key, name, customModelData, glow, List.of(conditions), Optional.empty());
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData, List<PriorityProvider.Selector<SpawnContext, SpawnCondition>> conditions, List<PriorityProvider.Selector<SpawnContext, SpawnCondition>> fishingOverride) {
            this.register(context, key, name, customModelData, false, conditions, Optional.of(fishingOverride));
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData, boolean glow, PriorityProvider.Selector<SpawnContext, SpawnCondition> conditions) {
            this.register(context, key, name, customModelData, glow, List.of(conditions), Optional.empty());
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData, boolean glow, SpawnCondition condition) {
            this.register(context, key, name, customModelData, glow, List.of(this.select(condition, 0)), Optional.empty());
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData, boolean glow, PriorityProvider.Selector<SpawnContext, SpawnCondition> conditions, List<PriorityProvider.Selector<SpawnContext, SpawnCondition>> fishingOverride) {
            this.register(context, key, name, customModelData, glow, List.of(conditions), Optional.of(fishingOverride));
        }

        public void register(BootstrapContext<T> context, ResourceKey<T> key, String name, int customModelData, boolean glow, List<PriorityProvider.Selector<SpawnContext, SpawnCondition>> conditions, Optional<List<PriorityProvider.Selector<SpawnContext, SpawnCondition>>> fishingOverride) {
            ResourceLocation texture = FishOfThieves.id("entity/" + this.entityName + "/" + name);
            ResourceLocation glowTexture = FishOfThieves.id("entity/" + this.entityName + "/" + name + "_glow");
            context.register(key, this.factory.apply((Object)name, (Object)new ClientAsset.ResourceTexture(texture), glow ? Optional.of(new ClientAsset.ResourceTexture(glowTexture)) : Optional.empty(), (Object)new SpawnSettings(new SpawnPrioritySelectors(conditions), fishingOverride.map(SpawnPrioritySelectors::new)), (Object)customModelData));
        }
    }
}

