/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.CoconutFrondsBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTFoliagePlacerTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CoconutFrondsPlacer
extends FoliagePlacer {
    public static final MapCodec<CoconutFrondsPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CoconutFrondsPlacer.frondsPart(instance).apply((Applicative)instance, CoconutFrondsPlacer::new));
    protected final int height;
    protected final int maxLeavesLengthFromLocalY;
    protected final List<Pair<Integer, Integer>> reduceLeavesLength;

    protected static <P extends CoconutFrondsPlacer> Products.P3<RecordCodecBuilder.Mu<P>, Integer, Integer, List<Pair<Integer, Integer>>> frondsPart(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)Codec.intRange((int)0, (int)8).fieldOf("height").forGetter(placer -> placer.height)).and((App)Codec.intRange((int)0, (int)8).fieldOf("max_leaves_length_from_local_y").forGetter(placer -> placer.maxLeavesLengthFromLocalY)).and((App)Codec.mapPair((MapCodec)Codec.intRange((int)0, (int)16).fieldOf("at_tree_height"), (MapCodec)Codec.intRange((int)0, (int)8).fieldOf("reduce_by")).codec().listOf().fieldOf("reduce_leaves_length").forGetter(placer -> placer.reduceLeavesLength));
    }

    public CoconutFrondsPlacer(int height, int maxLeavesLengthFromLocalY, List<Pair<Integer, Integer>> reduceLeavesLength) {
        super((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0));
        this.height = height;
        this.maxLeavesLengthFromLocalY = maxLeavesLengthFromLocalY;
        this.reduceLeavesLength = reduceLeavesLength;
    }

    protected FoliagePlacerType<?> type() {
        return FOTFoliagePlacerTypes.COCONUT_FRONDS_PLACER;
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.pos();
        if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)pos)) {
            for (int localY = offset; localY >= offset - foliageHeight; --localY) {
                if (localY == 0) {
                    BlockState blockState = FOTBlocks.VERTICAL_COCONUT_FRONDS.defaultBlockState();
                    if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(pos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
                    }
                    blockSetter.set(pos, blockState);
                    continue;
                }
                BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
                int maxLeavesFromLocalYLength = this.maxLeavesLengthFromLocalY - localY;
                for (Pair<Integer, Integer> reduceLeavesLength : this.reduceLeavesLength) {
                    if (maxFreeTreeHeight != (Integer)reduceLeavesLength.getFirst()) continue;
                    maxLeavesFromLocalYLength -= ((Integer)reduceLeavesLength.getSecond()).intValue();
                }
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Direction direction2 = direction.getOpposite();
                    BlockPos blockPos2 = mutableBlockPos.offset(direction2.getStepX(), localY, direction2.getStepZ());
                    boolean isPositiveDir = direction2.getAxisDirection() == Direction.AxisDirection.POSITIVE;
                    BlockState blockState = (BlockState)config.foliageProvider.getState(random, pos).setValue((Property)CoconutFrondsBlock.FACING, (Comparable)direction2);
                    if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isFluidAtPosition(pos, fluidState -> fluidState.isSourceOfType((Fluid)Fluids.WATER))));
                    }
                    if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)blockPos2)) {
                        blockSetter.set(blockPos2, blockState);
                    }
                    block7: for (int leavesLength = 0; leavesLength < maxLeavesFromLocalYLength; ++leavesLength) {
                        blockState = leavesLength == maxLeavesFromLocalYLength - 1 ? (BlockState)blockState.setValue(CoconutFrondsBlock.PART, (Comparable)((Object)CoconutFrondsBlock.Part.TAIL)) : (BlockState)blockState.setValue(CoconutFrondsBlock.PART, (Comparable)((Object)CoconutFrondsBlock.Part.MIDDLE));
                        switch (direction.getAxis()) {
                            case X: {
                                int x;
                                int n = x = isPositiveDir ? direction2.getStepX() + leavesLength : direction2.getStepX() - leavesLength;
                                if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)blockPos2.offset(x, 0, 0))) continue block7;
                                blockSetter.set(blockPos2.offset(x, 0, 0), blockState);
                                continue block7;
                            }
                            case Z: {
                                int z;
                                int n = z = isPositiveDir ? direction2.getStepZ() + leavesLength : direction2.getStepZ() - leavesLength;
                                if (!TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)blockPos2.offset(0, 0, z))) continue block7;
                                blockSetter.set(blockPos2.offset(0, 0, z), blockState);
                            }
                        }
                    }
                }
            }
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && (random.nextInt(2) == 0 || localY == 0);
    }
}

