/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.ItemLike;

public class FOTSpawnEggItem
extends SpawnEggItem {
    public FOTSpawnEggItem(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack itemStack) {
        TypedEntityData entityData;
        MutableComponent name = super.getName(itemStack).copy();
        if (FishOfThieves.CONFIG.general.displayTrophySpawnEggInCreativeTab && (entityData = (TypedEntityData)itemStack.get(DataComponents.ENTITY_DATA)) != null && entityData.copyTagWithoutId().getBooleanOr("Trophy", false)) {
            return name.append(" (").append((Component)Component.translatable((String)"entity.fishofthieves.trophy")).append(")");
        }
        return name;
    }

    public static void addTrophySpawnEgg(CreativeModeTab.Output output, Item item) {
        if (FishOfThieves.CONFIG.general.displayTrophySpawnEggInCreativeTab) {
            output.accept(FOTSpawnEggItem.create(item, false));
            output.accept(FOTSpawnEggItem.create(item, true));
        } else {
            output.accept((ItemLike)item);
        }
    }

    private static ItemStack create(Item item, boolean trophy) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.set(DataComponents.ENTITY_DATA, (Object)TypedEntityData.of((Object)((EntityType)((TypedEntityData)itemStack.get(DataComponents.ENTITY_DATA)).type()), (CompoundTag)((CompoundTag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putBoolean("Trophy", trophy)))));
        return itemStack;
    }
}

