/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot;

import com.google.common.collect.Maps;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.loot.function.FOTLootItem;
import com.stevekung.fishofthieves.loot.function.FOTTagEntry;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTLootItemConditions;
import com.stevekung.fishofthieves.registry.FOTLootTables;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class FOTLootManager {
    public static void dropWorms(List<ItemStack> droppedList, BlockState blockState, ReloadableServerRegistries.Holder holder, LootParams lootParams) {
        if (FishOfThieves.CONFIG.general.enableEarthwormsDrop && blockState.is(FOTTags.Blocks.EARTHWORMS_DROPS) && !blockState.is(FOTTags.Blocks.EARTHWORMS_DROP_BLACKLIST)) {
            droppedList.addAll((Collection<ItemStack>)holder.getLootTable(FOTLootTables.Blocks.EARTHWORMS_DROPS).getRandomItems(lootParams));
        }
        if (FishOfThieves.CONFIG.general.enableGrubsDrop && blockState.is(FOTTags.Blocks.GRUBS_DROPS)) {
            droppedList.addAll((Collection<ItemStack>)holder.getLootTable(FOTLootTables.Blocks.GRUBS_DROPS).getRandomItems(lootParams));
        }
        if (FishOfThieves.CONFIG.general.enableLeechesDrop && blockState.is(FOTTags.Blocks.LEECHES_DROPS)) {
            droppedList.addAll((Collection<ItemStack>)holder.getLootTable(FOTLootTables.Blocks.LEECHES_DROPS).getRandomItems(lootParams));
        }
    }

    public static Map<ResourceKey<LootTable>, BiFunction<LootPool.Builder, HolderLookup.Provider, LootPool.Builder>> getInjectedLootTableMap() {
        return (Map)Util.make((Object)Maps.newHashMap(), map -> {
            map.put(BuiltInLootTables.FISHERMAN_GIFT, (builder, provider) -> FOTLootManager.getFishermanGiftLoot(builder));
            map.put(BuiltInLootTables.FISHING_FISH, FOTLootManager::getFishingLoot);
            EntityType.POLAR_BEAR.getDefaultLootTable().ifPresent(key -> map.put(key, FOTLootManager::getPolarBearLoot));
            EntityType.DOLPHIN.getDefaultLootTable().ifPresent(key -> map.put(key, FOTLootManager::getDolphinLoot));
            map.put(BuiltInLootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY, (builder, provider) -> FOTLootManager.getOceanRuinsArchaeologyLoot(builder));
            map.put(BuiltInLootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY, (builder, provider) -> FOTLootManager.getOceanRuinsArchaeologyLoot(builder));
        });
    }

    public static Map<ResourceKey<LootTable>, BiFunction<LootPool.Builder, HolderLookup.Provider, LootPool.Builder>> getInjectedLootPoolMap() {
        return (Map)Util.make((Object)Maps.newHashMap(), map -> {
            EntityType.GUARDIAN.getDefaultLootTable().ifPresent(key -> map.put(key, (builder, provider) -> FOTLootManager.getGuardianLoot(builder, provider, false)));
            EntityType.ELDER_GUARDIAN.getDefaultLootTable().ifPresent(key -> map.put(key, (builder, provider) -> FOTLootManager.getGuardianLoot(builder, provider, true)));
            map.put(BuiltInLootTables.VILLAGE_FISHER, (builder, provider) -> FOTLootManager.getVillageFisherLoot(builder));
            map.put(BuiltInLootTables.BURIED_TREASURE, (builder, provider) -> FOTLootManager.getBuriedTreasureLoot(builder));
            map.put(BuiltInLootTables.SHIPWRECK_SUPPLY, (builder, provider) -> FOTLootManager.getShipwreckSupplyLoot(builder));
            map.put(BuiltInLootTables.JUNGLE_TEMPLE, FOTLootManager::getJungleTempleLoot);
        });
    }

    public static LootPool.Builder getFishermanGiftLoot(LootPool.Builder builder) {
        return builder.add(FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL)).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.PONDIE)).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.ISLEHOPPER)).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.ANCIENTSCALE)).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.PLENTIFIN)).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.WILDSPLASH)).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.DEVILFISH)).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.BATTLEGILL)).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.WRECKER)).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.STORMFISH).when(FOTLootItemConditions.THUNDERING));
    }

    public static LootPool.Builder getFishingLoot(LootPool.Builder builder, HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup structureLookup = provider.lookupOrThrow(Registries.STRUCTURE);
        HolderLookup.RegistryLookup biomeLookup = provider.lookupOrThrow(Registries.BIOME);
        return builder.add(FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL).setWeight(50).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_SPLASHTAILS))))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.PONDIE).setWeight(50).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_PONDIES))))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.ISLEHOPPER).setWeight(40).when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_ISLEHOPPERS))).and((LootItemCondition.Builder)FOTLootItemConditions.COAST_CONTINENTALNESS.and((LootItemCondition.Builder)FOTLootItemConditions.LOW_PEAKTYPE.or(FOTLootItemConditions.MID_PEAKTYPE).or(FOTLootItemConditions.VALLEY_PEAKTYPE))))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.ANCIENTSCALE).setWeight(40).when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_ANCIENTSCALES))).or(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setStructures((HolderSet)structureLookup.getOrThrow(FOTTags.Structures.ANCIENTSCALES_SPAWN_IN)))))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.PLENTIFIN).setWeight(45).when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_PLENTIFINS))).or(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setStructures((HolderSet)structureLookup.getOrThrow(FOTTags.Structures.PLENTIFINS_SPAWN_IN)))))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.WILDSPLASH).setWeight(45).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_WILDSPLASH))))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.DEVILFISH).setWeight(35).when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_DEVILFISH))).and((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setY(MinMaxBounds.Doubles.atMost((double)0.0))).and(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.DEVILFISH_CANNOT_SPAWN))).invert())))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.BATTLEGILL).setWeight(35).when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_BATTLEGILLS))).and((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setStructures((HolderSet)structureLookup.getOrThrow(FOTTags.Structures.BATTLEGILLS_SPAWN_IN))).or(FOTLootItemConditions.HAS_RAIDS)))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.WRECKER).setWeight(20).when((LootItemCondition.Builder)LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setStructures((HolderSet)structureLookup.getOrThrow(FOTTags.Structures.WRECKERS_SPAWN_IN))).and(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_WRECKERS)))))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.STORMFISH).setWeight(20).when((LootItemCondition.Builder)FOTLootItemConditions.THUNDERING.and(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)biomeLookup.getOrThrow(FOTTags.Biomes.SPAWNS_STORMFISH))))));
    }

    public static LootPool.Builder getGuardianLoot(LootPool.Builder builder, HolderLookup.Provider provider, boolean elder) {
        int weight = elder ? 3 : 2;
        return builder.setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL).setWeight(weight).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider)))).add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.BATTLEGILL).setWeight(weight).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider))));
    }

    public static LootPool.Builder getDolphinLoot(LootPool.Builder builder, HolderLookup.Provider provider) {
        return builder.add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider)))).add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.ANCIENTSCALE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider)))).add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.PLENTIFIN).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider)))).add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.WILDSPLASH).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider)))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.STORMFISH).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider))).when(FOTLootItemConditions.THUNDERING));
    }

    public static LootPool.Builder getPolarBearLoot(LootPool.Builder builder, HolderLookup.Provider provider) {
        return builder.add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider))).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.ANCIENTSCALE).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider))).setWeight(6).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.PLENTIFIN).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider))).setWeight(6).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.WILDSPLASH).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider))).setWeight(6).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.WRECKER).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider))).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).add(FOTLootItem.lootTableItem((ItemLike)FOTItems.STORMFISH).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)FOTLootManager.shouldSmeltLoot(provider))).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(FOTLootItemConditions.THUNDERING));
    }

    public static LootPool.Builder getOceanRuinsArchaeologyLoot(LootPool.Builder builder) {
        return builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTBlocks.FISH_BONE)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.STORMFISH_POTTERY_SHERD)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.KRAKEN_POTTERY_SHERD)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.MEGALODON_POTTERY_SHERD));
    }

    public static LootPool.Builder getVillageFisherLoot(LootPool.Builder builder) {
        return builder.add((LootPoolEntryContainer.Builder)FOTTagEntry.expandTag(FOTTags.Items.THIEVES_FISH).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f))));
    }

    public static LootPool.Builder getBuriedTreasureLoot(LootPool.Builder builder) {
        return builder.setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)TagEntry.expandTag(FOTTags.Items.COOKED_THIEVES_FISH).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f))));
    }

    public static LootPool.Builder getShipwreckSupplyLoot(LootPool.Builder builder) {
        return builder.setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.BANANA).setWeight(9).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)6.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.COCONUT).setWeight(7).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.POMEGRANATE).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.MANGO).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.PINEAPPLE).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))));
    }

    public static LootPool.Builder getJungleTempleLoot(LootPool.Builder builder, HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup biomeLookup = provider.lookupOrThrow(Registries.BIOME);
        return builder.setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.BANANA).setWeight(9).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)})))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.POMEGRANATE).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)6.0f)))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)})))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.MANGO).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)})))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)FOTItems.PINEAPPLE).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBiomes((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)}))));
    }

    public static AnyOfCondition.Builder shouldSmeltLoot(HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup registryLookup = provider.lookupOrThrow(Registries.ENCHANTMENT);
        return AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true)))), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().equipment(EntityEquipmentPredicate.Builder.equipment().mainhand(ItemPredicate.Builder.item().withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.ENCHANTMENTS, (DataComponentPredicate)EnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((HolderSet)registryLookup.getOrThrow(EnchantmentTags.SMELTS_LOOT), MinMaxBounds.Ints.ANY)))).build()))))});
    }
}

