/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.entity;

import com.stevekung.fishofthieves.entity.BucketableEntityType;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={EntityType.class})
public abstract class MixinEntityType<T extends Entity>
implements BucketableEntityType<T> {
    @Shadow
    @Nullable
    abstract T create(Level var1, EntitySpawnReason var2);

    @Nullable
    public T fishofthieves$spawnByBucket(ServerLevel serverLevel, @Nullable ItemStack stack, @Nullable Player player, EntitySpawnReason entitySpawnReason) {
        Consumer consumer = stack != null ? EntityType.createDefaultStackConfig((Level)serverLevel, (ItemStack)stack, (LivingEntity)player) : entity -> {};
        return this.fishofthieves$spawnByBucket(serverLevel, consumer, entitySpawnReason);
    }

    @Override
    @Nullable
    public T fishofthieves$spawnByBucket(ServerLevel level, @Nullable Consumer<T> consumer, EntitySpawnReason entitySpawnReason) {
        T entity = this.fishofthieves$createByBucket(level, consumer, entitySpawnReason);
        if (entity != null) {
            level.addFreshEntityWithPassengers(entity);
        }
        return entity;
    }

    @Override
    @Nullable
    public T fishofthieves$createByBucket(ServerLevel level, @Nullable Consumer<T> consumer, EntitySpawnReason entitySpawnReason) {
        T entity = this.create((Level)level, entitySpawnReason);
        if (entity == null) {
            return null;
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(mob.blockPosition()), entitySpawnReason, null);
        }
        if (consumer != null) {
            consumer.accept(entity);
        }
        return entity;
    }
}

