/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.entity;

import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FallingBlockEntity.class})
public abstract class MixinFallingBlockEntity
extends Entity {
    @Shadow
    BlockState blockState;

    MixinFallingBlockEntity() {
        super(null, null);
    }

    @Inject(method={"causeFallDamage(DFLnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="RETURN", ordinal=2)})
    private void fishofthieves$crushPomegranateToRedDye(double fallDistance, float multiplier, DamageSource source, CallbackInfoReturnable<Boolean> info) {
        if (this.blockState.is(BlockTags.ANVIL)) {
            boolean crush = false;
            ItemStack itemStack = ItemStack.EMPTY;
            List<ItemEntity> itemEntities = this.level().getEntities((Entity)this, this.getBoundingBox(), ItemEntity.class::isInstance).stream().map(ItemEntity.class::cast).filter(itemEntity -> itemEntity.getItem().is(FOTItems.POMEGRANATE)).toList();
            for (ItemEntity itemEntity2 : itemEntities) {
                ItemStack itemStackFromEntity;
                itemStack = itemStackFromEntity = itemEntity2.getItem().copy();
                int count = itemStackFromEntity.getCount();
                itemEntity2.setItem(new ItemStack((ItemLike)Items.RED_DYE, count));
                crush = true;
            }
            if (crush) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), FOTSoundEvents.CRUSH_POMEGRANATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!itemStack.isEmpty()) {
                    for (ServerPlayer serverPlayer : this.level().getEntities(EntityTypeTest.forClass(Player.class), new AABB(this.blockPosition()).inflate(8.0), ServerPlayer.class::isInstance).stream().map(ServerPlayer.class::cast).toList()) {
                        FOTCriteriaTriggers.FALLING_ANVIL_CRUSH_ITEM.trigger(serverPlayer, itemStack);
                    }
                }
            }
        }
    }
}

