/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllConditionCheck;
import com.stevekung.fishofthieves.entity.condition.ContinentalnessCheck;
import com.stevekung.fishofthieves.entity.condition.MinimumBlockRangeCheck;
import com.stevekung.fishofthieves.entity.condition.NightCheck;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCheck;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCheck;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.WildsplashVariant;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.utils.Continentalness;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.level.biome.Biomes;

public class WildsplashVariants {
    public static final ResourceKey<WildsplashVariant> RUSSET = WildsplashVariants.createKey("russet");
    public static final ResourceKey<WildsplashVariant> SANDY = WildsplashVariants.createKey("sandy");
    public static final ResourceKey<WildsplashVariant> OCEAN = WildsplashVariants.createKey("ocean");
    public static final ResourceKey<WildsplashVariant> MUDDY = WildsplashVariants.createKey("muddy");
    public static final ResourceKey<WildsplashVariant> CORAL = WildsplashVariants.createKey("coral");

    public static void bootstrap(BootstrapContext<WildsplashVariant> context) {
        AbstractFishVariant.RegisterContext<WildsplashVariant> registerContext = AbstractFishVariant.RegisterContext.create("wildsplash", WildsplashVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, RUSSET, "russet", 0);
        registerContext.register(context, SANDY, "sandy", 1, registerContext.select(new BiomeCheck((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)})), 1), registerContext.select(AllConditionCheck.allOf(new SpawnCondition[]{new BiomeCheck((HolderSet)biomeLookup.getOrThrow(BiomeTags.IS_BEACH)), ContinentalnessCheck.continentalness(Continentalness.COAST)}), 0));
        registerContext.register(context, OCEAN, "ocean", 2, (SpawnCondition)new BiomeCheck((HolderSet)biomeLookup.getOrThrow(BiomeTags.IS_OCEAN)));
        registerContext.register(context, MUDDY, "muddy", 3, AllConditionCheck.allOf(new SpawnCondition[]{ProbabilityCheck.defaultRareProbablity(), new BiomeCheck((HolderSet)biomeLookup.getOrThrow(BiomeTags.HAS_CLOSER_WATER_FOG))}));
        registerContext.register(context, CORAL, "coral", 4, true, AllConditionCheck.allOf(new SpawnCondition[]{NightCheck.night(), SeeSkyCheck.seeSky(), new BiomeCheck((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.WARM_OCEAN)})), MinimumBlockRangeCheck.minimumBlocksInRange(Optional.of(context.lookup(Registries.BLOCK).getOrThrow(FOTTags.Blocks.CORAL_WILDSPLASH_SPAWNABLE_ON)), Optional.empty(), 4, 24)}));
    }

    public static void bootstrapSimple(BootstrapContext<WildsplashVariant> context) {
        AbstractFishVariant.RegisterContext<WildsplashVariant> registerContext = AbstractFishVariant.RegisterContext.create("wildsplash", WildsplashVariant::new);
        registerContext.register(context, RUSSET, "russet", 0);
        registerContext.register(context, SANDY, "sandy", 1);
        registerContext.register(context, OCEAN, "ocean", 2);
        registerContext.register(context, MUDDY, "muddy", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, CORAL, "coral", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    private static ResourceKey<WildsplashVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.WILDSPLASH_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

