/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.ai.WreckerAi;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.WreckerVariants;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1480;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class Wrecker
extends AbstractThievesFish<WreckerVariant> {
    private static final class_2940<WreckerVariant> VARIANT = class_2945.method_12791(Wrecker.class, FOTDataSerializers.WRECKER_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)class_156.method_654((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:rose", (Object)0);
        map.put((Object)"fishofthieves:sun", (Object)1);
        map.put((Object)"fishofthieves:blackcloud", (Object)2);
        map.put((Object)"fishofthieves:snow", (Object)3);
        map.put((Object)"fishofthieves:moon", (Object)4);
    });
    private static final ImmutableList<class_4149<? extends class_4148<? super Wrecker>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, (Object)class_4149.field_18469, FOTSensorTypes.EARTHWORMS_THIEVES_FISH_TEMPTATIONS, FOTSensorTypes.NEAREST_WRECKER_LOCATED, FOTSensorTypes.NEAREST_MAGMA_BLOCK, FOTSensorTypes.WRECKER_ATTACKABLES, FOTSensorTypes.LOW_BRIGHTNESS);
    private static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18445, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_22474, FOTMemoryModuleTypes.NEAREST_WRECKER_LOCATED, FOTMemoryModuleTypes.NEAREST_LOW_BRIGHTNESS, (Object)class_4140.field_30243, (Object)class_4140.field_22355, (Object)class_4140.field_22475, (Object[])new class_4140[]{class_4140.field_28326, class_4140.field_28327, class_4140.field_28325, class_4140.field_18448, class_4140.field_39408, class_4140.field_30244, FOTMemoryModuleTypes.BREACHED_TICK});

    public Wrecker(class_1299<? extends Wrecker> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected class_4095.class_5303<Wrecker> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return WreckerAi.makeBrain((class_4095<Wrecker>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Wrecker> method_18868() {
        return super.method_18868();
    }

    @Override
    protected void method_5958() {
        this.method_37908().method_16107().method_15396("wreckerBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15405("wreckerActivityUpdate");
        WreckerAi.updateActivity(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public double method_33191(class_1309 entity) {
        return 0.5 + (double)entity.method_17681() * 2.0;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)WreckerVariants.ROSE);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        WreckerAi.initMemories(this);
    }

    @Override
    public class_2378<WreckerVariant> getRegistry() {
        return FOTRegistry.WRECKER_VARIANT;
    }

    @Override
    public void setVariant(WreckerVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    @Override
    public WreckerVariant getVariant() {
        return (WreckerVariant)this.field_6011.method_12789(VARIANT);
    }

    @Override
    public class_6880<WreckerVariant> getSpawnVariant(boolean fromBucket) {
        return this.getSpawnVariant((class_1309)this, FOTTags.FishVariant.DEFAULT_WRECKER_SPAWNS, WreckerVariants.ROSE, fromBucket);
    }

    @Override
    public BiMap<String, Integer> variantToCustomModelData() {
        return VARIANT_TO_INT;
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)FOTItems.WRECKER_BUCKET);
    }

    protected class_3414 method_6002() {
        return FOTSoundEvents.WRECKER_DEATH;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return FOTSoundEvents.WRECKER_HURT;
    }

    protected class_3414 method_6457() {
        return FOTSoundEvents.WRECKER_FLOP;
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.isTrophy() ? super.method_18377(pose) : class_4048.method_18385((float)0.275f, (float)0.25f);
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return this.isTrophy() ? 0.34f : 0.175f;
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        spawnData = super.method_5943(level, difficulty, reason, spawnData, dataTag);
        if (this.isTrophy()) {
            this.method_5996(class_5134.field_23721).method_6192(2.5);
        }
        return spawnData;
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.method_5996(class_5134.field_23721).method_6192(2.5);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(class_1799 itemStack) {
        return EARTHWORMS_FOOD.method_8093(itemStack);
    }

    public static boolean checkSpawnRules(class_1299<? extends class_1480> entityType, class_5425 level, class_3730 mobSpawnType, class_2338 blockPos, class_5819 random) {
        boolean isWater = level.method_8316(blockPos).method_15767(class_3486.field_15517) && level.method_8320(blockPos).method_27852(class_2246.field_10382);
        return isWater && TerrainUtils.isInFeature(level.method_8410(), blockPos, FOTTags.Structures.WRECKERS_SPAWN_IN);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23717, 10.0).method_26868(class_5134.field_23721, 1.5).method_26868(class_5134.field_23722, 0.01);
    }

    @Nullable
    public static class_2338 getNearestShipwreckOrRuinedPortalPos(class_3218 level, class_2338 pos) {
        return level.method_8487(FOTTags.Structures.WRECKERS_LOCATED, pos, 32, false);
    }
}

