/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTStructures;
import com.stevekung.fishofthieves.structure.GuardianFruitTreePiece;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3499;
import net.minecraft.class_4966;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_7138;
import net.minecraft.class_7151;

public class GuardianFruitTreeStructure
extends class_3195 {
    private static final String[] GUARDIAN_FRUIT_TREES = (String[])IntStream.rangeClosed(1, 5).mapToObj(value -> "guardian_fruit_tree_" + value).toArray(String[]::new);
    public static final Codec<GuardianFruitTreeStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("fruit_chance").forGetter(structure -> Float.valueOf(structure.fruitChance)), (App)GuardianFruitTreeStructure.method_42697((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, GuardianFruitTreeStructure::new));
    private final float fruitChance;

    public GuardianFruitTreeStructure(float fruitChance, class_3195.class_7302 settings) {
        super(settings);
        this.fruitChance = fruitChance;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2919 worldgenRandom = context.comp_566();
        class_2960 resourceLocation = FishOfThieves.id(GUARDIAN_FRUIT_TREES[worldgenRandom.method_43048(GUARDIAN_FRUIT_TREES.length)]);
        class_3499 structureTemplate = context.comp_565().method_15091(resourceLocation);
        class_2470 rotation = class_2470.method_16548((class_5819)worldgenRandom);
        class_2415 mirror = worldgenRandom.method_43057() < 0.5f ? class_2415.field_11302 : class_2415.field_11301;
        class_2338 blockPos = new class_2338(structureTemplate.method_15160().method_10263() / 2, 0, structureTemplate.method_15160().method_10260() / 2);
        class_2794 chunkGenerator = context.comp_562();
        class_5539 levelHeightAccessor = context.comp_569();
        class_7138 randomState = context.comp_564();
        class_2338 blockPos2 = context.comp_568().method_8323();
        class_3341 boundingBox = structureTemplate.method_27267(blockPos2, rotation, blockPos, mirror);
        class_2338 blockPos3 = boundingBox.method_22874();
        int height = chunkGenerator.method_16397(blockPos3.method_10263(), blockPos3.method_10260(), class_2902.class_2903.field_13195, levelHeightAccessor, randomState) - 1;
        int y = GuardianFruitTreeStructure.findSuitableY(chunkGenerator, height, boundingBox, levelHeightAccessor, randomState);
        class_2338 blockPos4 = new class_2338(blockPos2.method_10263(), y, blockPos2.method_10260());
        return Optional.of(new class_3195.class_7150(blockPos4, structurePiecesBuilder -> structurePiecesBuilder.method_35462((class_3443)new GuardianFruitTreePiece(context.comp_565(), blockPos4, resourceLocation, rotation, mirror, blockPos, this.fruitChance))));
    }

    private static int findSuitableY(class_2794 chunkGenerator, int height, class_3341 box, class_5539 level, class_7138 randomState) {
        int l;
        int i = level.method_31607() + 15;
        ImmutableList list = ImmutableList.of((Object)new class_2338(box.method_35415(), 0, box.method_35417()), (Object)new class_2338(box.method_35418(), 0, box.method_35417()), (Object)new class_2338(box.method_35415(), 0, box.method_35420()), (Object)new class_2338(box.method_35418(), 0, box.method_35420()));
        List<class_4966> list2 = list.stream().map(blockPos -> chunkGenerator.method_26261(blockPos.method_10263(), blockPos.method_10260(), level, randomState)).toList();
        for (l = height; l > i; --l) {
            int m = 0;
            for (class_4966 noiseColumn : list2) {
                class_2680 blockState = noiseColumn.method_32892(l);
                if (!class_2902.class_2903.field_13195.method_16402().test(blockState) || ++m != 3) continue;
                return l;
            }
        }
        return l;
    }

    public class_7151<?> method_41618() {
        return FOTStructures.Type.GUARDIAN_FRUIT_TREE;
    }
}

