/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.api.block.FishPlaqueRegistry;
import com.stevekung.fishofthieves.config.FishOfThievesConfig;
import com.stevekung.fishofthieves.entity.animal.Ancientscale;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.entity.animal.Devilfish;
import com.stevekung.fishofthieves.entity.animal.Islehopper;
import com.stevekung.fishofthieves.entity.animal.Plentifin;
import com.stevekung.fishofthieves.entity.animal.Pondie;
import com.stevekung.fishofthieves.entity.animal.Splashtail;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import com.stevekung.fishofthieves.entity.animal.Wildsplash;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.registry.FOTBlockPredicateTypes;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTBoatTypes;
import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTDisplayItems;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTEntitySubPredicate;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTLootItemFunctions;
import com.stevekung.fishofthieves.registry.FOTLootPoolEntries;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTStructures;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.Util;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import org.slf4j.Logger;

public class FishOfThieves {
    public static final String MOD_ID = "fishofthieves";
    public static final String MOD_RESOURCES = "fishofthieves:";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final FishOfThievesConfig CONFIG = (FishOfThievesConfig)AutoConfig.register(FishOfThievesConfig.class, GsonConfigSerializer::new).getConfig();
    public static final ResourceKey<CreativeModeTab> FOT_MAIN = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)FishOfThieves.id("fot_main"));
    public static final ResourceKey<CreativeModeTab> FOT_FISH = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)FishOfThieves.id("fot"));

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static void init() {
        FOTSoundEvents.init();
        FOTCriteriaTriggers.init();
    }

    public static void initCommon() {
        FOTDataSerializers.init();
        FOTLootItemFunctions.init();
        FOTLootPoolEntries.init();
        FOTStructures.init();
        FOTEntitySubPredicate.init();
        FOTBlockPredicateTypes.init();
        if (FOTPlatform.isModLoaded("naturalist")) {
            FishPlaqueRegistry.registerInteractionItem(Items.f_42446_, "naturalist:snail");
        }
        if (FOTPlatform.isModLoaded("alexsmobs")) {
            FishPlaqueRegistry.registerInteractionItem(Items.f_42446_, "alexsmobs:cosmic_cod");
            FishPlaqueRegistry.registerInteractionItem(Items.f_42448_, "alexsmobs:stradpole");
        }
        if (FOTPlatform.isModLoaded("alexscaves")) {
            FishPlaqueRegistry.registerInteractionItem((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation("alexscaves", "acid_bucket")), "alexscaves:radgill");
        }
        DispenseItemBehavior bucket = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42447_);
        DispenserBlock.m_52672_((ItemLike)FOTItems.SPLASHTAIL_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.PONDIE_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.ISLEHOPPER_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.ANCIENTSCALE_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.PLENTIFIN_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.WILDSPLASH_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.DEVILFISH_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.BATTLEGILL_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.WRECKER_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.STORMFISH_BUCKET, (DispenseItemBehavior)bucket);
        DispenserBlock.m_52672_((ItemLike)FOTItems.COCONUT_BOAT, (DispenseItemBehavior)new BoatDispenseItemBehavior(FOTBoatTypes.COCONUT));
        DispenserBlock.m_52672_((ItemLike)FOTItems.COCONUT_CHEST_BOAT, (DispenseItemBehavior)new BoatDispenseItemBehavior(FOTBoatTypes.COCONUT, true));
        PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)FOTItems.PLENTIFIN, (Potion)Potions.f_43595_);
        PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)FOTItems.ISLEHOPPER, (Potion)Potions.f_43621_);
        FOTPlatform.addComposting(FOTItems.EARTHWORMS, 0.4f);
        FOTPlatform.addComposting(FOTItems.GRUBS, 0.4f);
        FOTPlatform.addComposting(FOTItems.LEECHES, 0.4f);
        FOTPlatform.addComposting(FOTItems.COCONUT, 0.5f);
        FOTPlatform.addComposting(FOTItems.BANANA, 0.3f);
        FOTPlatform.addComposting(FOTItems.PINEAPPLE, 0.7f);
        FOTPlatform.addComposting(FOTItems.CROWNLESS_PINEAPPLE, 0.65f);
        FOTPlatform.addComposting(FOTItems.HALF_PINEAPPLE, 0.35f);
        FOTPlatform.addComposting(FOTItems.PINEAPPLE_SEEDS, 0.1f);
        FOTPlatform.addComposting(FOTItems.PINEAPPLE_CROWN, 0.15f);
        FOTPlatform.addComposting(FOTItems.MANGO, 0.3f);
        FOTPlatform.addComposting(FOTItems.RAW_MANGO, 0.3f);
        FOTPlatform.addComposting(FOTItems.MANGO_PIT, 0.2f);
        FOTPlatform.addComposting(FOTItems.POMEGRANATE, 0.2f);
        FOTPlatform.addComposting(FOTItems.POMEGRANATE_SEEDS, 0.1f);
        FOTPlatform.addComposting(FOTItems.PINK_PLUMERIA, 0.6f);
        FOTPlatform.addComposting(FOTItems.LIGHT_BLUE_PLUMERIA, 0.6f);
        FOTPlatform.addComposting(FOTItems.WHITE_PLUMERIA, 0.6f);
        FOTPlatform.addComposting(FOTItems.COCONUT_FRONDS, 0.8f);
        FOTPlatform.addComposting(FOTItems.BANANA_LEAVES, 0.8f);
        FOTPlatform.addComposting(FOTItems.BANANA_BLOSSOM, 0.3f);
        FOTPlatform.addComposting(FOTItems.BANANA_SHOOTS, 0.25f);
        FOTPlatform.addComposting(FOTItems.UNDERRIPE_BANANA_CLUSTER, 0.5f);
        FOTPlatform.addComposting(FOTItems.BARELY_RIPE_BANANA_CLUSTER, 0.85f);
        FOTPlatform.addComposting(FOTItems.RIPE_BANANA_CLUSTER, 0.85f);
        FOTPlatform.addComposting(FOTItems.BANANA_STEM, 0.8f);
        FOTPlatform.addComposting(FOTItems.UNDERRIPE_PINEAPPLE_BLOCK, 0.6f);
        FOTPlatform.addComposting(FOTItems.RIPE_PINEAPPLE_BLOCK, 0.75f);
        FOTPlatform.addComposting(FOTItems.CROWNLESS_RIPE_PINEAPPLE_BLOCK, 0.7f);
        FOTPlatform.addComposting(FOTItems.MANGO_LEAVES, 0.3f);
        FOTPlatform.addComposting(FOTItems.MANGO_SAPLING, 0.25f);
        FOTPlatform.addComposting(FOTItems.POMEGRANATE_PLANT, 0.25f);
        FOTPlatform.addComposting(FOTItems.TALL_POMEGRANATE_PLANT, 0.4f);
        FOTPlatform.addComposting(FOTItems.TROPICAL_RED_FERN, 0.4f);
        FOTPlatform.addComposting(FOTItems.TROPICAL_MONSTERA, 0.3f);
        FOTPlatform.addComposting(FOTItems.GUARDIAN_FRUIT, 0.3f);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FRONDS, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_LEAVES, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.VERTICAL_COCONUT_FRONDS, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.VERTICAL_BANANA_LEAVES, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.PINK_PLUMERIA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.LIGHT_BLUE_PLUMERIA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.WHITE_PLUMERIA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_SAPLING, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_PLANKS, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FENCE, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FENCE_GATE, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_SLAB, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_STAIRS, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FRUIT, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.SMALL_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FRUIT_GROWABLE_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.SMALL_TOP_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.SMALL_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.MEDIUM_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.MEDIUM_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_MEDIUM_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_MEDIUM_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_SMALL_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_SMALL_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_STEM, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_CLUSTER_GROWABLE_STEM, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.PRISMARIZED_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BUDDING_PRISMARIZED_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_LEAVES, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_SHOOTS_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_SHOOTS, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_SAPLING, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_PIT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_FRUIT, 30, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.POMEGRANATE_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.TALL_POMEGRANATE_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_BLOSSOM, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_BLOSSOM_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.POMEGRANATE_SAPLING, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.TROPICAL_RED_FERN, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.TROPICAL_MONSTERA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.RIPE_BANANA_CLUSTER_PLANT, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.UNDERRIPE_BANANA_CLUSTER, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.RIPE_BANANA_CLUSTER, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.UNDERRIPE_PINEAPPLE_BLOCK, 30, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.CROWNLESS_RIPE_PINEAPPLE_BLOCK, 30, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.RIPE_PINEAPPLE_BLOCK, 30, 20);
    }

    private static List<VillagerTrades.ItemListing> getFishermanTradesByLevel(int level, List<VillagerTrades.ItemListing> list) {
        switch (level) {
            case 1: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.SPLASHTAIL, 6, FOTItems.COOKED_SPLASHTAIL, 6, 8, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.PONDIE, 6, FOTItems.COOKED_PONDIE, 6, 8, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.ISLEHOPPER, 2, 2, FOTItems.COOKED_ISLEHOPPER, 2, 8, 2));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.ANCIENTSCALE, 3, FOTItems.COOKED_ANCIENTSCALE, 3, 5, 3));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.EARTHWORMS, 48, 8, 10));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.GRUBS, 32, 8, 12));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.LEECHES, 24, 8, 14));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.SPLASHTAIL_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.PONDIE_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.ISLEHOPPER_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.ANCIENTSCALE_BUCKET, 3, 1, 16, 1));
                break;
            }
            case 2: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.SPLASHTAIL, 12, 8, 12));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.PONDIE, 12, 8, 12));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.ISLEHOPPER, 8, 8, 15));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.ANCIENTSCALE, 8, 9, 15));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.PLENTIFIN, 3, 2, FOTItems.COOKED_PLENTIFIN, 3, 5, 3));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.WILDSPLASH, 4, 2, FOTItems.COOKED_WILDSPLASH, 4, 6, 3));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.DEVILFISH, 4, 3, FOTItems.COOKED_DEVILFISH, 4, 6, 4));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.PLENTIFIN_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.WILDSPLASH_BUCKET, 3, 1, 16, 1));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.DEVILFISH_BUCKET, 3, 1, 16, 1));
                break;
            }
            case 3: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.PLENTIFIN, 8, 9, 17));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.WILDSPLASH, 8, 9, 17));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.DEVILFISH, 6, 10, 20));
                break;
            }
            case 4: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.BATTLEGILL, 6, 10, 20));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.WRECKER, 5, 12, 25));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.EmeraldForItems((ItemLike)FOTItems.STORMFISH, 5, 12, 25));
                break;
            }
            case 5: {
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.BATTLEGILL, 4, 3, FOTItems.COOKED_BATTLEGILL, 4, 6, 4));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.WRECKER, 5, 5, FOTItems.COOKED_WRECKER, 5, 8, 5));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)FOTItems.STORMFISH, 5, 5, FOTItems.COOKED_STORMFISH, 5, 8, 8));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.BATTLEGILL_BUCKET, 6, 1, 8, 2));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.WRECKER_BUCKET, 6, 1, 8, 2));
                list.add((VillagerTrades.ItemListing)new VillagerTrades.ItemsForEmeralds(FOTItems.STORMFISH_BUCKET, 6, 1, 8, 2));
            }
        }
        return list;
    }

    public static CreativeModeTab.Builder getFishCreativeTabBuilder(CreativeModeTab.Builder builder) {
        return builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.fishofthieves.fish")).m_257737_(() -> new ItemStack((ItemLike)FOTItems.SPLASHTAIL)).m_257501_(FOTDisplayItems::displayFishItems);
    }

    public static CreativeModeTab.Builder getMainCreativeTabBuilder(CreativeModeTab.Builder builder) {
        return builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.fishofthieves.main")).m_257737_(() -> new ItemStack((ItemLike)FOTBlocks.COCONUT_LOG)).m_257501_(FOTDisplayItems::displayMainItems);
    }

    public static Int2ObjectOpenHashMap<Function<List<VillagerTrades.ItemListing>, List<VillagerTrades.ItemListing>>> getFishermanTrades() {
        return (Int2ObjectOpenHashMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), map -> IntStream.rangeClosed(1, 5).boxed().forEach(level -> map.put(level.intValue(), list -> FishOfThieves.getFishermanTradesByLevel(level, list))));
    }

    public static Map<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> getEntityAttributes() {
        return (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
            map.put(FOTEntities.SPLASHTAIL, AbstractFish.m_27495_());
            map.put(FOTEntities.PONDIE, AbstractFish.m_27495_());
            map.put(FOTEntities.ISLEHOPPER, AbstractFish.m_27495_());
            map.put(FOTEntities.ANCIENTSCALE, AbstractFish.m_27495_());
            map.put(FOTEntities.PLENTIFIN, AbstractFish.m_27495_());
            map.put(FOTEntities.WILDSPLASH, AbstractFish.m_27495_());
            map.put(FOTEntities.DEVILFISH, Devilfish.createAttributes());
            map.put(FOTEntities.BATTLEGILL, Battlegill.createAttributes());
            map.put(FOTEntities.WRECKER, Wrecker.createAttributes());
            map.put(FOTEntities.STORMFISH, AbstractFish.m_27495_());
        });
    }

    public static List<SpawnPlacementEntry<Mob>> getSpawnPlacements() {
        return ((ArrayList)Util.m_137469_((Object)Lists.newArrayList(), list -> {
            list.add(new SpawnPlacementEntry<Splashtail>(FOTEntities.SPLASHTAIL, WaterAnimal::m_218282_));
            list.add(new SpawnPlacementEntry<Pondie>(FOTEntities.PONDIE, WaterAnimal::m_218282_));
            list.add(new SpawnPlacementEntry<Islehopper>(FOTEntities.ISLEHOPPER, Islehopper::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Ancientscale>(FOTEntities.ANCIENTSCALE, Ancientscale::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Plentifin>(FOTEntities.PLENTIFIN, Plentifin::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Wildsplash>(FOTEntities.WILDSPLASH, Wildsplash::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Devilfish>(FOTEntities.DEVILFISH, Devilfish::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Battlegill>(FOTEntities.BATTLEGILL, Battlegill::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Wrecker>(FOTEntities.WRECKER, Wrecker::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Stormfish>(FOTEntities.STORMFISH, Stormfish::checkSpawnRules));
        })).stream().map(entry -> entry).toList();
    }

    public record SpawnPlacementEntry<T extends Mob>(EntityType<T> type, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
    }
}

